/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.SQLSegmentConverter;

public final class SimpleTableConverter
implements SQLSegmentConverter<SimpleTableSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convert(SimpleTableSegment segment) {
        TableNameSegment tableName = segment.getTableName();
        ArrayList<String> names = new ArrayList<String>();
        if (segment.getOwner().isPresent()) {
            this.addOwnerNames(names, (OwnerSegment)segment.getOwner().get());
        }
        names.add(tableName.getIdentifier().getValue());
        SqlIdentifier tableNameSQLNode = new SqlIdentifier(names, SqlParserPos.ZERO);
        if (segment.getAliasName().isPresent()) {
            SqlIdentifier aliasSQLNode = new SqlIdentifier((String)segment.getAliasName().get(), SqlParserPos.ZERO);
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, Arrays.asList(tableNameSQLNode, aliasSQLNode), SqlParserPos.ZERO));
        }
        return Optional.of(tableNameSQLNode);
    }

    private void addOwnerNames(List<String> names, OwnerSegment owner) {
        if (null != owner) {
            this.addOwnerNames(names, owner.getOwner().orElse(null));
            names.add(owner.getIdentifier().getValue());
        }
    }
}

