/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.statement.delete;

import java.util.Optional;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.DeleteStatementHandler;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.with.WithConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.statement.SQLStatementConverter;

public final class DeleteStatementConverter
implements SQLStatementConverter<DeleteStatement, SqlNode> {
    @Override
    public SqlNode convert(DeleteStatement deleteStatement) {
        SqlNode sqlDelete = this.convertDelete(deleteStatement);
        SqlNodeList orderBy = DeleteStatementHandler.getOrderBySegment((DeleteStatement)deleteStatement).flatMap(optional -> new OrderByConverter().convert((OrderBySegment)optional)).orElse(SqlNodeList.EMPTY);
        Optional limit = DeleteStatementHandler.getLimitSegment((DeleteStatement)deleteStatement);
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, sqlDelete, orderBy, offset, rowCount);
        }
        return orderBy.isEmpty() ? sqlDelete : new SqlOrderBy(SqlParserPos.ZERO, sqlDelete, orderBy, null, null);
    }

    private SqlNode convertDelete(DeleteStatement deleteStatement) {
        SqlNode deleteTable = new TableConverter().convert(deleteStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlNode condition = deleteStatement.getWhere().flatMap(optional -> new WhereConverter().convert((WhereSegment)optional)).orElse(null);
        SqlIdentifier alias = deleteStatement.getTable().getAliasName().map(optional -> new SqlIdentifier(optional, SqlParserPos.ZERO)).orElse(null);
        SqlDelete sqlDelete = new SqlDelete(SqlParserPos.ZERO, deleteTable, condition, null, alias);
        Optional with = DeleteStatementHandler.getWithSegment((DeleteStatement)deleteStatement);
        if (with.isPresent()) {
            return (SqlNode)new WithConverter().convert((WithSegment)DeleteStatementHandler.getWithSegment((DeleteStatement)deleteStatement).get(), (SqlNode)sqlDelete).get();
        }
        return sqlDelete;
    }
}

