/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlValuesOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.groupby.GroupByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.groupby.HavingConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.projection.DistinctConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.projection.ProjectionsConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.window.WindowConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.statement.SQLStatementConverter;

public final class InsertStatementConverter
implements SQLStatementConverter<InsertStatement, SqlNode> {
    @Override
    public SqlNode convert(InsertStatement insertStatement) {
        return this.convertInsert(insertStatement);
    }

    private SqlInsert convertInsert(InsertStatement insertStatement) {
        SqlNode table = new TableConverter().convert((TableSegment)insertStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlParserPos position = SqlParserPos.ZERO;
        SqlNodeList keywords = new SqlNodeList(position);
        SqlNode source = insertStatement.getInsertSelect().isPresent() ? this.convertSelect((SubquerySegment)insertStatement.getInsertSelect().get()) : this.convertValues(insertStatement.getValues());
        SqlNodeList columnList = this.convertColumn(insertStatement.getColumns());
        return new SqlInsert(SqlParserPos.ZERO, keywords, table, source, columnList);
    }

    private SqlNode convertSelect(SubquerySegment subquerySegment) {
        SelectStatement selectStatement = subquerySegment.getSelect();
        SqlNodeList distinct = new DistinctConverter().convert(selectStatement.getProjections()).orElse(null);
        SqlNodeList projection = new ProjectionsConverter().convert(selectStatement.getProjections()).orElseThrow(IllegalStateException::new);
        SqlNode from = new TableConverter().convert(selectStatement.getFrom()).orElse(null);
        SqlNode where = selectStatement.getWhere().flatMap(optional -> new WhereConverter().convert((WhereSegment)optional)).orElse(null);
        SqlNodeList groupBy = selectStatement.getGroupBy().flatMap(optional -> new GroupByConverter().convert((GroupBySegment)optional)).orElse(null);
        SqlNode having = selectStatement.getHaving().flatMap(optional -> new HavingConverter().convert((HavingSegment)optional)).orElse(null);
        SqlNodeList window = SelectStatementHandler.getWindowSegment((SelectStatement)selectStatement).flatMap(new WindowConverter()::convert).orElse(SqlNodeList.EMPTY);
        return new SqlSelect(SqlParserPos.ZERO, distinct, projection, from, where, groupBy, having, window, null, null, null, null, SqlNodeList.EMPTY);
    }

    private SqlNode convertValues(Collection<InsertValuesSegment> insertValuesSegments) {
        ArrayList<SqlNode> values = new ArrayList<SqlNode>();
        for (InsertValuesSegment each : insertValuesSegments) {
            for (ExpressionSegment value : each.getValues()) {
                values.add(this.convertExpression(value));
            }
        }
        ArrayList<SqlBasicCall> operands = new ArrayList<SqlBasicCall>();
        operands.add(new SqlBasicCall((SqlOperator)new SqlRowOperator("ROW"), values, SqlParserPos.ZERO));
        return new SqlBasicCall((SqlOperator)new SqlValuesOperator(), operands, SqlParserPos.ZERO);
    }

    private SqlNodeList convertColumn(Collection<ColumnSegment> columnSegments) {
        List columns = columnSegments.stream().map(each -> new ColumnConverter().convert((ColumnSegment)each).orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        if (columns.isEmpty()) {
            return SqlNodeList.EMPTY;
        }
        return new SqlNodeList(columns, SqlParserPos.ZERO);
    }

    private SqlNode convertExpression(ExpressionSegment expressionSegment) {
        return new ExpressionConverter().convert(expressionSegment).orElseThrow(IllegalStateException::new);
    }
}

