/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.statement.select;

import java.util.Arrays;
import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.groupby.GroupByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.groupby.HavingConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.projection.DistinctConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.projection.ProjectionsConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.window.WindowConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.statement.SQLStatementConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.type.CombineOperatorConverter;

public final class SelectStatementConverter
implements SQLStatementConverter<SelectStatement, SqlNode> {
    @Override
    public SqlNode convert(SelectStatement selectStatement) {
        SqlSelect sqlSelect = this.convertSelect(selectStatement);
        SqlNode sqlCombine = this.convertCombine((SqlNode)sqlSelect, selectStatement);
        SqlNodeList orderBy = selectStatement.getOrderBy().flatMap(optional -> new OrderByConverter().convert((OrderBySegment)optional)).orElse(SqlNodeList.EMPTY);
        Optional limit = SelectStatementHandler.getLimitSegment((SelectStatement)selectStatement);
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, sqlCombine, orderBy, offset, rowCount);
        }
        return orderBy.isEmpty() ? sqlCombine : new SqlOrderBy(SqlParserPos.ZERO, sqlCombine, orderBy, null, null);
    }

    private SqlSelect convertSelect(SelectStatement selectStatement) {
        SqlNodeList distinct = new DistinctConverter().convert(selectStatement.getProjections()).orElse(null);
        SqlNodeList projection = new ProjectionsConverter().convert(selectStatement.getProjections()).orElseThrow(IllegalStateException::new);
        SqlNode from = new TableConverter().convert(selectStatement.getFrom()).orElse(null);
        SqlNode where = selectStatement.getWhere().flatMap(optional -> new WhereConverter().convert((WhereSegment)optional)).orElse(null);
        SqlNodeList groupBy = selectStatement.getGroupBy().flatMap(optional -> new GroupByConverter().convert((GroupBySegment)optional)).orElse(null);
        SqlNode having = selectStatement.getHaving().flatMap(optional -> new HavingConverter().convert((HavingSegment)optional)).orElse(null);
        SqlNodeList window = SelectStatementHandler.getWindowSegment((SelectStatement)selectStatement).flatMap(new WindowConverter()::convert).orElse(SqlNodeList.EMPTY);
        return new SqlSelect(SqlParserPos.ZERO, distinct, projection, from, where, groupBy, having, window, null, null, null, null, SqlNodeList.EMPTY);
    }

    private SqlNode convertCombine(SqlNode sqlNode, SelectStatement selectStatement) {
        if (selectStatement.getCombine().isPresent()) {
            CombineSegment combineSegment = (CombineSegment)selectStatement.getCombine().get();
            return new SqlBasicCall(CombineOperatorConverter.convert(combineSegment.getCombineType()), Arrays.asList(this.convert(combineSegment.getLeft()), this.convert(combineSegment.getRight())), SqlParserPos.ZERO);
        }
        return sqlNode;
    }
}

