/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.statement.update;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.UpdateStatementHandler;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.converter.statement.SQLStatementConverter;

public final class UpdateStatementConverter
implements SQLStatementConverter<UpdateStatement, SqlNode> {
    @Override
    public SqlNode convert(UpdateStatement updateStatement) {
        SqlUpdate sqlUpdate = this.convertUpdate(updateStatement);
        SqlNodeList orderBy = UpdateStatementHandler.getOrderBySegment((UpdateStatement)updateStatement).flatMap(optional -> new OrderByConverter().convert((OrderBySegment)optional)).orElse(SqlNodeList.EMPTY);
        Optional limit = UpdateStatementHandler.getLimitSegment((UpdateStatement)updateStatement);
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(optional -> new PaginationValueSQLConverter().convert((PaginationValueSegment)optional)).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlUpdate, orderBy, offset, rowCount);
        }
        return orderBy.isEmpty() ? sqlUpdate : new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlUpdate, orderBy, null, null);
    }

    private SqlUpdate convertUpdate(UpdateStatement updateStatement) {
        SqlNode table = new TableConverter().convert(updateStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlNode condition = updateStatement.getWhere().flatMap(optional -> new WhereConverter().convert((WhereSegment)optional)).orElse(null);
        SqlNodeList columns = new SqlNodeList(SqlParserPos.ZERO);
        SqlNodeList expressions = new SqlNodeList(SqlParserPos.ZERO);
        for (AssignmentSegment each : ((SetAssignmentSegment)updateStatement.getAssignmentSegment().orElseThrow(IllegalStateException::new)).getAssignments()) {
            columns.addAll(this.convertColumn(each.getColumns()));
            expressions.add(this.convertExpression(each.getValue()));
        }
        return new SqlUpdate(SqlParserPos.ZERO, table, columns, expressions, condition, null, null);
    }

    private List<SqlNode> convertColumn(List<ColumnSegment> columnSegments) {
        return columnSegments.stream().map(each -> new ColumnConverter().convert((ColumnSegment)each).orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
    }

    private SqlNode convertExpression(ExpressionSegment expressionSegment) {
        return new ExpressionConverter().convert(expressionSegment).orElseThrow(IllegalStateException::new);
    }
}

