/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.converter.type;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.shardingsphere.sql.parser.sql.common.enums.CombineType;

public final class CombineOperatorConverter {
    private static final Map<CombineType, SqlOperator> REGISTRY = new EnumMap<CombineType, SqlOperator>(CombineType.class);

    private static void registerCombine() {
        REGISTRY.put(CombineType.UNION, (SqlOperator)SqlStdOperatorTable.UNION);
        REGISTRY.put(CombineType.UNION_ALL, (SqlOperator)SqlStdOperatorTable.UNION_ALL);
        REGISTRY.put(CombineType.INTERSECT, (SqlOperator)SqlStdOperatorTable.INTERSECT);
        REGISTRY.put(CombineType.INTERSECT_ALL, (SqlOperator)SqlStdOperatorTable.INTERSECT_ALL);
        REGISTRY.put(CombineType.EXCEPT, (SqlOperator)SqlStdOperatorTable.EXCEPT);
        REGISTRY.put(CombineType.EXCEPT_ALL, (SqlOperator)SqlStdOperatorTable.EXCEPT_ALL);
        REGISTRY.put(CombineType.MINUS, (SqlOperator)SqlStdOperatorTable.EXCEPT);
        REGISTRY.put(CombineType.MINUS_ALL, (SqlOperator)SqlStdOperatorTable.EXCEPT_ALL);
    }

    public static SqlOperator convert(CombineType combineType) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(combineType), (String)"Unsupported combine type: `%s`", (Object)combineType);
        return REGISTRY.get(combineType);
    }

    @Generated
    private CombineOperatorConverter() {
    }

    static {
        CombineOperatorConverter.registerCombine();
    }
}

