/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.metadata.schema;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.util.SQLFederationDataTypeUtils;
import org.apache.shardingsphere.sqlfederation.compiler.statistic.SQLFederationStatistic;

public final class SQLFederationSchema
extends AbstractSchema {
    private final String name;
    private final Map<String, Table> tableMap;

    public SQLFederationSchema(String schemaName, ShardingSphereSchema schema, DatabaseType protocolType, JavaTypeFactory javaTypeFactory) {
        this.name = schemaName;
        this.tableMap = this.createTableMap(schema, protocolType, javaTypeFactory);
    }

    private Map<String, Table> createTableMap(ShardingSphereSchema schema, DatabaseType protocolType, JavaTypeFactory javaTypeFactory) {
        LinkedHashMap<String, Table> result = new LinkedHashMap<String, Table>(schema.getTables().size(), 1.0f);
        for (ShardingSphereTable each : schema.getTables().values()) {
            if (schema.containsView(each.getName())) {
                result.put(each.getName().toLowerCase(), (Table)this.getViewTable(schema, each, protocolType, javaTypeFactory));
                continue;
            }
            result.put(each.getName().toLowerCase(), (Table)new SQLFederationTable(each, new SQLFederationStatistic(), protocolType));
        }
        return result;
    }

    private ViewTable getViewTable(ShardingSphereSchema schema, ShardingSphereTable table, DatabaseType protocolType, JavaTypeFactory javaTypeFactory) {
        RelDataType relDataType = SQLFederationDataTypeUtils.createRelDataType(table, protocolType, (RelDataTypeFactory)javaTypeFactory);
        ShardingSphereView view = schema.getView(table.getName());
        return new ViewTable(javaTypeFactory.getJavaClass(relDataType), RelDataTypeImpl.proto((RelDataType)relDataType), view.getViewDefinition(), Collections.emptyList(), Collections.emptyList());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

