/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.metadata.schema;

import java.lang.reflect.Type;
import java.util.Collections;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.util.SQLFederationDataTypeUtils;
import org.apache.shardingsphere.sqlfederation.compiler.statistic.SQLFederationStatistic;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.EnumerableScanExecutor;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.EnumerableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.row.EmptyRowEnumerator;

public final class SQLFederationTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ShardingSphereTable table;
    private final SQLFederationStatistic statistic;
    private final DatabaseType protocolType;
    private EnumerableScanExecutor scanExecutor;

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return SQLFederationDataTypeUtils.createRelDataType(this.table, this.protocolType, typeFactory);
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedSQLOperationException("asQueryable");
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return LogicalTableScan.create((RelOptCluster)context.getCluster(), (RelOptTable)relOptTable, Collections.emptyList());
    }

    public Enumerable<Object> execute(DataContext root, String sql, int[] paramIndexes) {
        if (null == this.scanExecutor) {
            return this.createEmptyEnumerable();
        }
        return this.scanExecutor.execute(this.table, new EnumerableScanExecutorContext(root, sql, paramIndexes));
    }

    private AbstractEnumerable<Object> createEmptyEnumerable() {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyRowEnumerator();
            }
        };
    }

    public String toString() {
        return "SQLFederationTable";
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    @Generated
    public SQLFederationTable(ShardingSphereTable table, SQLFederationStatistic statistic, DatabaseType protocolType) {
        this.table = table;
        this.statistic = statistic;
        this.protocolType = protocolType;
    }

    @Generated
    public void setScanExecutor(EnumerableScanExecutor scanExecutor) {
        this.scanExecutor = scanExecutor;
    }
}

