/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.shardingsphere.sqlfederation.compiler.operator.logical.LogicalScan;
import org.apache.shardingsphere.sqlfederation.compiler.planner.rule.transformation.ImmutablePushFilterIntoScanRule;
import org.immutables.value.Value;

@Value.Enclosing
public final class PushFilterIntoScanRule
extends RelRule<Config>
implements TransformationRule {
    private static final Collection<String> SYSTEM_SCHEMAS = new HashSet<String>(Arrays.asList("information_schema", "performance_schema", "mysql", "sys", "shardingsphere", "pg_catalog"));
    private static final String CORRELATE_REFERENCE = "$cor";

    private PushFilterIntoScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalScan logicalScan = (LogicalScan)call.rel(1);
        for (String each : logicalScan.getTable().getQualifiedName()) {
            if (!SYSTEM_SCHEMAS.contains(each.toLowerCase())) continue;
            return false;
        }
        LogicalFilter logicalFilter = (LogicalFilter)call.rel(0);
        RexNode condition = logicalFilter.getCondition();
        return !(condition instanceof RexCall) || !this.containsCorrelate(((RexCall)condition).getOperands());
    }

    private boolean containsCorrelate(Collection<RexNode> operands) {
        for (RexNode each : operands) {
            if (!each.toString().contains(CORRELATE_REFERENCE)) continue;
            return true;
        }
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalFilter logicalFilter = (LogicalFilter)call.rel(0);
        LogicalScan logicalScan = (LogicalScan)call.rel(1);
        logicalScan.pushDown(logicalFilter);
        call.transformTo((RelNode)logicalScan);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutablePushFilterIntoScanRule.Config.builder().description(PushFilterIntoScanRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(LogicalFilter.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(LogicalScan.class).anyInputs()})).build();

        default public PushFilterIntoScanRule toRule() {
            return new PushFilterIntoScanRule(this);
        }
    }
}

