/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtils;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationCompilerEngine;
import org.apache.shardingsphere.sqlfederation.compiler.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.compiler.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.sqlfederation.compiler.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.compiler.planner.cache.ExecutionPlanCacheKey;
import org.apache.shardingsphere.sqlfederation.compiler.statement.SQLStatementCompiler;
import org.apache.shardingsphere.sqlfederation.executor.SQLFederationDataContext;
import org.apache.shardingsphere.sqlfederation.executor.SQLFederationExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.TableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.EnumerableScanExecutor;
import org.apache.shardingsphere.sqlfederation.resultset.SQLFederationResultSet;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class SQLFederationEngine
implements AutoCloseable {
    private static final int DEFAULT_METADATA_VERSION = 0;
    private final Map<ShardingSphereRule, SQLFederationDecider> deciders;
    private final String databaseName;
    private final String schemaName;
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereStatistics statistics;
    private final JDBCExecutor jdbcExecutor;
    private final SQLFederationRule sqlFederationRule;
    private ResultSet resultSet;

    public SQLFederationEngine(String databaseName, String schemaName, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics, JDBCExecutor jdbcExecutor) {
        this.deciders = OrderedSPILoader.getServices(SQLFederationDecider.class, (Collection)metaData.getDatabase(databaseName).getRuleMetaData().getRules());
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.metaData = metaData;
        this.statistics = statistics;
        this.jdbcExecutor = jdbcExecutor;
        this.sqlFederationRule = (SQLFederationRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLFederationRule.class);
    }

    public boolean decide(SQLStatementContext sqlStatementContext, List<Object> parameters, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        if (this.isQuerySystemSchema(sqlStatementContext, database)) {
            return true;
        }
        boolean sqlFederationEnabled = this.sqlFederationRule.getConfiguration().isSqlFederationEnabled();
        if (!sqlFederationEnabled || !(sqlStatementContext instanceof SelectStatementContext)) {
            return false;
        }
        HashSet includedDataNodes = new HashSet();
        for (Map.Entry<ShardingSphereRule, SQLFederationDecider> entry : this.deciders.entrySet()) {
            boolean isUseSQLFederation = entry.getValue().decide((SelectStatementContext)sqlStatementContext, parameters, globalRuleMetaData, database, entry.getKey(), includedDataNodes);
            if (!isUseSQLFederation) continue;
            return true;
        }
        return false;
    }

    private boolean isQuerySystemSchema(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database) {
        return sqlStatementContext instanceof SelectStatementContext && (SystemSchemaUtils.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)sqlStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database) || SystemSchemaUtils.isOpenGaussSystemCatalogQuery((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)((SelectStatementContext)sqlStatementContext).getSqlStatement().getProjections().getProjections()));
    }

    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext) {
        String databaseName = federationContext.getQueryContext().getDatabaseNameFromSQLStatement().orElse(this.databaseName);
        String schemaName = federationContext.getQueryContext().getSchemaNameFromSQLStatement().orElse(this.schemaName);
        SQLFederationExecutionPlan executionPlan = this.compileQuery(prepareEngine, callback, federationContext, databaseName, schemaName);
        Bindable executablePlan = EnumerableInterpretable.toBindable(Collections.emptyMap(), null, (EnumerableRel)((EnumerableRel)executionPlan.getPhysicalPlan()), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
        Map<String, Object> params = this.createParameters(federationContext.getQueryContext().getParameters());
        OptimizerPlannerContext plannerContext = this.sqlFederationRule.getOptimizerContext().getPlannerContext(databaseName);
        Enumerator enumerator = executablePlan.bind((DataContext)new SQLFederationDataContext(plannerContext.getValidator(schemaName), plannerContext.getConverter(schemaName), params)).enumerator();
        ShardingSphereSchema schema = federationContext.getMetaData().getDatabase(databaseName).getSchema(schemaName);
        SchemaPlus sqlFederationSchema = plannerContext.getValidator(schemaName).getCatalogReader().getRootSchema().plus().getSubSchema(schemaName);
        this.resultSet = new SQLFederationResultSet((Enumerator<Object>)enumerator, schema, (Schema)sqlFederationSchema, (SelectStatementContext)federationContext.getQueryContext().getSqlStatementContext(), executionPlan.getResultColumnType());
        return this.resultSet;
    }

    private SQLFederationExecutionPlan compileQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext, String databaseName, String schemaName) {
        SQLStatementContext sqlStatementContext = federationContext.getQueryContext().getSqlStatementContext();
        ShardingSpherePreconditions.checkState((boolean)(sqlStatementContext instanceof SelectStatementContext), () -> new IllegalArgumentException("SQL statement context must be select statement context."));
        OptimizerPlannerContext plannerContext = this.sqlFederationRule.getOptimizerContext().getPlannerContext(databaseName);
        SchemaPlus sqlFederationSchema = plannerContext.getValidator(schemaName).getCatalogReader().getRootSchema().plus().getSubSchema(schemaName);
        this.registerTableScanExecutor((Schema)sqlFederationSchema, prepareEngine, callback, federationContext, this.sqlFederationRule.getOptimizerContext(), databaseName, schemaName);
        SQLStatementCompiler sqlStatementCompiler = new SQLStatementCompiler(plannerContext.getConverter(schemaName));
        SQLFederationCompilerEngine compilerEngine = new SQLFederationCompilerEngine(databaseName, schemaName, this.sqlFederationRule.getConfiguration().getExecutionPlanCache());
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        return compilerEngine.compile(this.buildCacheKey(federationContext, selectStatementContext, sqlStatementCompiler, databaseName, schemaName), false);
    }

    private ExecutionPlanCacheKey buildCacheKey(SQLFederationExecutorContext federationContext, SelectStatementContext selectStatementContext, SQLStatementCompiler sqlStatementCompiler, String databaseName, String schemaName) {
        ShardingSphereSchema schema = federationContext.getMetaData().getDatabase(databaseName).getSchema(schemaName);
        ExecutionPlanCacheKey result = new ExecutionPlanCacheKey(federationContext.getQueryContext().getSql(), (SQLStatement)selectStatementContext.getSqlStatement(), selectStatementContext.getDatabaseType().getType(), sqlStatementCompiler);
        for (String each : selectStatementContext.getTablesContext().getTableNames()) {
            ShardingSphereTable table = schema.getTable(each);
            ShardingSpherePreconditions.checkState((null != table ? 1 : 0) != 0, () -> new NoSuchTableException(each));
            result.getTableMetaDataVersions().put(table.getName(), 0);
        }
        return result;
    }

    private void registerTableScanExecutor(Schema sqlFederationSchema, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationExecutorContext federationContext, OptimizerContext optimizerContext, String databaseName, String schemaName) {
        if (null == sqlFederationSchema) {
            return;
        }
        TableScanExecutorContext executorContext = new TableScanExecutorContext(databaseName, schemaName, this.metaData.getProps(), federationContext);
        EnumerableScanExecutor scanExecutor = new EnumerableScanExecutor(prepareEngine, this.jdbcExecutor, callback, optimizerContext, this.metaData.getGlobalRuleMetaData(), executorContext, this.statistics);
        for (String each : this.metaData.getDatabase(databaseName).getSchema(schemaName).getAllTableNames()) {
            Table table = sqlFederationSchema.getTable(each);
            if (!(table instanceof SQLFederationTable)) continue;
            ((SQLFederationTable)table).setScanExecutor(scanExecutor);
        }
    }

    private Map<String, Object> createParameters(List<Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(params.size(), 1.0f);
        int index = 0;
        for (Object each : params) {
            result.put("?" + index++, each);
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (null != this.resultSet) {
            this.resultSet.close();
        }
    }

    @Generated
    public Map<ShardingSphereRule, SQLFederationDecider> getDeciders() {
        return this.deciders;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public ShardingSphereStatistics getStatistics() {
        return this.statistics;
    }

    @Generated
    public JDBCExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }

    @Generated
    public SQLFederationRule getSqlFederationRule() {
        return this.sqlFederationRule;
    }

    @Generated
    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

