/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.dialect.MssqlSqlDialect;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.OracleSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;

public final class SQLDialectFactory {
    private static final Map<String, SqlDialect> SQL_DIALECTS_REGISTRY = new HashMap<String, SqlDialect>();

    public static SqlDialect getSQLDialect(String databaseType) {
        return SQL_DIALECTS_REGISTRY.getOrDefault(databaseType, MysqlSqlDialect.DEFAULT);
    }

    @Generated
    private SQLDialectFactory() {
    }

    static {
        SQL_DIALECTS_REGISTRY.put("H2", MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("MySQL", MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("MariaDB", MysqlSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("Oracle", OracleSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("SQLServer", MssqlSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("PostgreSQL", PostgresqlSqlDialect.DEFAULT);
        SQL_DIALECTS_REGISTRY.put("openGauss", PostgresqlSqlDialect.DEFAULT);
    }
}

