/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.compiler.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.executor.SQLFederationExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.TableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.EnumerableScanExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.row.EmptyRowEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.row.MemoryEnumerator;
import org.apache.shardingsphere.sqlfederation.executor.row.SQLFederationRowEnumerator;

public final class EnumerableScanExecutor {
    private static final Collection<String> SYSTEM_CATALOG_TABLES = new HashSet<String>(3, 1.0f);
    private static final String DAT_COMPATIBILITY = "PG";
    private static final String PG_DATABASE = "pg_database";
    private static final String PG_TABLES = "pg_tables";
    private static final String PG_ROLES = "pg_roles";
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final OptimizerContext optimizerContext;
    private final RuleMetaData globalRuleMetaData;
    private final TableScanExecutorContext executorContext;
    private final ShardingSphereStatistics statistics;
    private final ProcessEngine processEngine = new ProcessEngine();

    public Enumerable<Object> execute(ShardingSphereTable table, EnumerableScanExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName().toLowerCase();
        String schemaName = this.executorContext.getSchemaName().toLowerCase();
        DatabaseType databaseType = this.optimizerContext.getParserContext(databaseName).getDatabaseType();
        if (new SystemDatabase(databaseType).getSystemSchemas().contains(schemaName)) {
            return this.executeByShardingSphereData(databaseName, schemaName, table, databaseType);
        }
        SQLFederationExecutorContext federationContext = this.executorContext.getFederationContext();
        QueryContext queryContext = this.createQueryContext(federationContext.getMetaData(), scanContext, databaseType, federationContext.getQueryContext().isUseCache());
        ShardingSphereDatabase database = federationContext.getMetaData().getDatabase(databaseName);
        ExecutionContext context = new KernelProcessor().generateExecutionContext(queryContext, database, this.globalRuleMetaData, this.executorContext.getProps(), new ConnectionContext());
        if (federationContext.isPreview()) {
            federationContext.getExecutionUnits().addAll(context.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.execute(queryContext, database, context);
    }

    private AbstractEnumerable<Object> execute(QueryContext queryContext, ShardingSphereDatabase database, ExecutionContext context) {
        try {
            this.computeConnectionOffsets(context);
            ExecutionGroupContext executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), this.executorContext.getConnectionOffsets(), context.getExecutionUnits(), new ExecutionGroupReportContext(database.getName()));
            this.setParameters(executionGroupContext.getInputGroups());
            this.processEngine.executeSQL(executionGroupContext, context.getQueryContext());
            List queryResults = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(QueryResult.class::cast).collect(Collectors.toList());
            MergeEngine mergeEngine = new MergeEngine(database, this.executorContext.getProps(), new ConnectionContext());
            MergedResult mergedResult = mergeEngine.merge(queryResults, queryContext.getSqlStatementContext());
            Collection<Statement> statements = this.getStatements(executionGroupContext.getInputGroups());
            AbstractEnumerable<Object> abstractEnumerable = this.createEnumerable(mergedResult, ((QueryResult)queryResults.get(0)).getMetaData(), statements);
            return abstractEnumerable;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
        finally {
            this.processEngine.completeSQLExecution();
        }
    }

    private void computeConnectionOffsets(ExecutionContext context) {
        for (ExecutionUnit each : context.getExecutionUnits()) {
            if (this.executorContext.getConnectionOffsets().containsKey(each.getDataSourceName())) {
                int connectionOffset = this.executorContext.getConnectionOffsets().get(each.getDataSourceName());
                this.executorContext.getConnectionOffsets().put(each.getDataSourceName(), ++connectionOffset);
                continue;
            }
            this.executorContext.getConnectionOffsets().put(each.getDataSourceName(), 0);
        }
    }

    private Enumerable<Object> executeByShardingSphereData(String databaseName, String schemaName, ShardingSphereTable table, DatabaseType databaseType) {
        if (databaseType instanceof OpenGaussDatabaseType && SYSTEM_CATALOG_TABLES.contains(table.getName().toLowerCase())) {
            return this.createMemoryEnumerator(this.createSystemCatalogTableData(table));
        }
        Optional<ShardingSphereTableData> tableData = Optional.ofNullable((ShardingSphereDatabaseData)this.statistics.getDatabaseData().get(databaseName)).map(optional -> (ShardingSphereSchemaData)optional.getSchemaData().get(schemaName)).map(ShardingSphereSchemaData::getTableData).map(shardingSphereData -> (ShardingSphereTableData)shardingSphereData.get(table.getName()));
        return tableData.map(this::createMemoryEnumerator).orElseGet(this::createEmptyEnumerable);
    }

    private ShardingSphereTableData createSystemCatalogTableData(ShardingSphereTable table) {
        ShardingSphereTableData result = new ShardingSphereTableData(table.getName());
        ShardingSphereMetaData metaData = this.executorContext.getFederationContext().getMetaData();
        if (PG_DATABASE.equalsIgnoreCase(table.getName())) {
            this.appendOpenGaussDatabaseData(result, metaData.getDatabases().values());
        } else if (PG_TABLES.equalsIgnoreCase(table.getName())) {
            for (ShardingSphereDatabase each : metaData.getDatabases().values()) {
                this.appendOpenGaussTableData(result, each.getSchemas());
            }
        } else if (PG_ROLES.equalsIgnoreCase(table.getName())) {
            this.appendOpenGaussRoleData(result, metaData);
        }
        return result;
    }

    private void appendOpenGaussDatabaseData(ShardingSphereTableData tableData, Collection<ShardingSphereDatabase> databases) {
        for (ShardingSphereDatabase each : databases) {
            Object[] rows = new Object[15];
            rows[0] = each.getName();
            rows[11] = DAT_COMPATIBILITY;
            tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
        }
    }

    private void appendOpenGaussTableData(ShardingSphereTableData tableData, Map<String, ShardingSphereSchema> schemas) {
        for (Map.Entry<String, ShardingSphereSchema> entry : schemas.entrySet()) {
            for (String each : entry.getValue().getAllTableNames()) {
                Object[] rows = new Object[10];
                rows[0] = entry.getKey();
                rows[1] = each;
                tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
            }
        }
    }

    private void appendOpenGaussRoleData(ShardingSphereTableData tableData, ShardingSphereMetaData metaData) {
        for (ShardingSphereUser each : ((AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class)).getConfiguration().getUsers()) {
            Object[] rows = new Object[27];
            rows[0] = each.getGrantee().getUsername();
            tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
        }
    }

    private Enumerable<Object> createMemoryEnumerator(final ShardingSphereTableData tableData) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new MemoryEnumerator(tableData.getRows());
            }
        };
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> params) {
        for (int i = 0; i < params.size(); ++i) {
            preparedStatement.setObject(i + 1, params.get(i));
        }
    }

    private AbstractEnumerable<Object> createEnumerable(final MergedResult mergedResult, final QueryResultMetaData metaData, final Collection<Statement> statements) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new SQLFederationRowEnumerator(mergedResult, metaData, statements);
            }
        };
    }

    private QueryContext createQueryContext(ShardingSphereMetaData metaData, EnumerableScanExecutorContext sqlString, DatabaseType databaseType, boolean useCache) {
        String sql = sqlString.getSql().replace("\n", " ");
        SQLStatement sqlStatement = new SQLStatementParserEngine(databaseType, this.optimizerContext.getSqlParserRule().getSqlStatementCache(), this.optimizerContext.getSqlParserRule().getParseTreeCache(), this.optimizerContext.getSqlParserRule().isSqlCommentParseEnabled()).parse(sql, useCache);
        List<Object> params = this.getParameters(sqlString.getParamIndexes());
        HintValueContext hintValueContext = new HintValueContext();
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaData, this.executorContext.getDatabaseName(), hintValueContext).bind(sqlStatement, params);
        return new QueryContext(sqlStatementContext, sql, params, hintValueContext, useCache);
    }

    private List<Object> getParameters(int[] paramIndexes) {
        if (null == paramIndexes) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int each : paramIndexes) {
            result.add(this.executorContext.getFederationContext().getQueryContext().getParameters().get(each));
        }
        return result;
    }

    private AbstractEnumerable<Object> createEmptyEnumerable() {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new EmptyRowEnumerator();
            }
        };
    }

    @Generated
    public EnumerableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, OptimizerContext optimizerContext, RuleMetaData globalRuleMetaData, TableScanExecutorContext executorContext, ShardingSphereStatistics statistics) {
        this.prepareEngine = prepareEngine;
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.optimizerContext = optimizerContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.executorContext = executorContext;
        this.statistics = statistics;
    }

    static {
        SYSTEM_CATALOG_TABLES.add(PG_DATABASE);
        SYSTEM_CATALOG_TABLES.add(PG_TABLES);
        SYSTEM_CATALOG_TABLES.add(PG_ROLES);
    }
}

