/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.resultset;

import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sqlfederation.resultset.WrapperAdapter;

public final class SQLFederationResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ShardingSphereSchema schema;
    private final Schema sqlFederationSchema;
    private final RelDataTypeFactory relDataTypeFactory;
    private final SelectStatementContext selectStatementContext;
    private final RelDataType resultColumnType;
    private final Map<Integer, String> indexAndColumnLabels;

    public SQLFederationResultSetMetaData(ShardingSphereSchema schema, Schema sqlFederationSchema, SelectStatementContext selectStatementContext, RelDataType resultColumnType, Map<Integer, String> indexAndColumnLabels) {
        this.schema = schema;
        this.sqlFederationSchema = sqlFederationSchema;
        this.relDataTypeFactory = new JavaTypeFactoryImpl();
        this.selectStatementContext = selectStatementContext;
        this.resultColumnType = resultColumnType;
        this.indexAndColumnLabels = indexAndColumnLabels;
    }

    @Override
    public int getColumnCount() {
        return this.resultColumnType.getFieldCount();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.sqlFederationSchema.getTable(optional)));
        return !table.isPresent() || ((Table)table.get()).getRowType(this.relDataTypeFactory).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.sqlFederationSchema.getTable(optional))).map(optional -> optional.getRowType(this.relDataTypeFactory).getPrecision()).orElse(0);
    }

    @Override
    public String getColumnLabel(int column) {
        if (this.indexAndColumnLabels.size() < column) {
            return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName();
        }
        return this.indexAndColumnLabels.get(column);
    }

    @Override
    public String getColumnName(int column) {
        List expandProjections = this.selectStatementContext.getProjectionsContext().getExpandProjections();
        if (expandProjections.size() < column) {
            return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName();
        }
        return ((Projection)expandProjections.get(column - 1)).getColumnName();
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.sqlFederationSchema.getTable(optional)));
        return !table.isPresent() || -1 == ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision();
    }

    @Override
    public int getScale(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.sqlFederationSchema.getTable(optional)));
        return !table.isPresent() || Integer.MIN_VALUE == ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale();
    }

    @Override
    public String getTableName(int column) {
        return this.findTableName(column).orElse("");
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) {
        return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType().getSqlTypeName().getJdbcOrdinal();
    }

    @Override
    public String getColumnTypeName(int column) {
        return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType().getSqlTypeName().getName();
    }

    @Override
    public boolean isReadOnly(int column) {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getType().getSqlTypeName().getClass().getName();
    }

    private Optional<String> findTableName(int column) {
        ColumnProjection projection;
        List expandProjections = this.selectStatementContext.getProjectionsContext().getExpandProjections();
        Object object = projection = expandProjections.size() < column ? new ColumnProjection(null, ((RelDataTypeField)this.resultColumnType.getFieldList().get(column - 1)).getName(), null, this.selectStatementContext.getDatabaseType()) : (Projection)expandProjections.get(column - 1);
        if (projection instanceof ColumnProjection) {
            return Optional.ofNullable(projection.getOriginalTable().getValue());
        }
        return Optional.empty();
    }
}

