/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.rule;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.scope.GlobalRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MetaDataHeldRule;
import org.apache.shardingsphere.sqlfederation.api.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.compiler.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.OptimizerContextFactory;
import org.apache.shardingsphere.sqlfederation.compiler.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.parser.dialect.OptimizerSQLPropertiesBuilder;
import org.apache.shardingsphere.sqlfederation.compiler.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.sqlfederation.compiler.context.planner.OptimizerPlannerContextFactory;

public final class SQLFederationRule
implements GlobalRule,
MetaDataHeldRule {
    private final SQLFederationRuleConfiguration configuration;
    private final OptimizerContext optimizerContext;

    public SQLFederationRule(SQLFederationRuleConfiguration ruleConfig, Map<String, ShardingSphereDatabase> databases, ConfigurationProperties props) {
        this.configuration = ruleConfig;
        this.optimizerContext = OptimizerContextFactory.create(databases, props);
    }

    public void alterDatabase(ShardingSphereDatabase database) {
        DatabaseType databaseType = database.getProtocolType();
        OptimizerParserContext parserContext = new OptimizerParserContext(databaseType, new OptimizerSQLPropertiesBuilder(databaseType).build());
        this.optimizerContext.putParserContext(database.getName(), parserContext);
        OptimizerPlannerContext plannerContext = OptimizerPlannerContextFactory.create(database, parserContext, this.optimizerContext.getSqlParserRule());
        this.optimizerContext.putPlannerContext(database.getName(), plannerContext);
    }

    public void dropDatabase(String databaseName) {
        this.optimizerContext.removeParserContext(databaseName);
        this.optimizerContext.removePlannerContext(databaseName);
    }

    @Generated
    public SQLFederationRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public OptimizerContext getOptimizerContext() {
        return this.optimizerContext;
    }
}

