/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.yaml.swapper;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.nodepath.GlobalNodePath;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.util.yaml.datanode.YamlDataNode;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.NewYamlGlobalRuleConfigurationSwapper;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sqlfederation.api.config.SQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.yaml.config.YamlSQLFederationRuleConfiguration;
import org.apache.shardingsphere.sqlfederation.yaml.swapper.YamlSQLFederationExecutionPlanCacheConfigurationSwapper;

public final class NewYamlSQLFederationRuleConfigurationSwapper
implements NewYamlGlobalRuleConfigurationSwapper<SQLFederationRuleConfiguration> {
    private final YamlSQLFederationExecutionPlanCacheConfigurationSwapper executionPlanCacheConfigSwapper = new YamlSQLFederationExecutionPlanCacheConfigurationSwapper();

    public Collection<YamlDataNode> swapToDataNodes(SQLFederationRuleConfiguration data) {
        return Collections.singletonList(new YamlDataNode(this.getRuleTagName().toLowerCase(), YamlEngine.marshal((Object)this.swapToYamlConfiguration(data))));
    }

    private YamlSQLFederationRuleConfiguration swapToYamlConfiguration(SQLFederationRuleConfiguration data) {
        YamlSQLFederationRuleConfiguration result = new YamlSQLFederationRuleConfiguration();
        result.setSqlFederationEnabled(data.isSqlFederationEnabled());
        result.setExecutionPlanCache(this.executionPlanCacheConfigSwapper.swapToYamlConfiguration(data.getExecutionPlanCache()));
        return result;
    }

    public Optional<SQLFederationRuleConfiguration> swapToObject(Collection<YamlDataNode> dataNodes) {
        for (YamlDataNode each : dataNodes) {
            Optional version = GlobalNodePath.getVersion((String)this.getRuleTagName().toLowerCase(), (String)each.getKey());
            if (!version.isPresent()) continue;
            return Optional.of(this.swapToObject((YamlSQLFederationRuleConfiguration)YamlEngine.unmarshal((String)each.getValue(), YamlSQLFederationRuleConfiguration.class)));
        }
        return Optional.empty();
    }

    private SQLFederationRuleConfiguration swapToObject(YamlSQLFederationRuleConfiguration yamlConfig) {
        CacheOption executionPlanCacheConfig = this.executionPlanCacheConfigSwapper.swapToObject(yamlConfig.getExecutionPlanCache());
        return new SQLFederationRuleConfiguration(yamlConfig.isSqlFederationEnabled(), executionPlanCacheConfig);
    }

    public Class<SQLFederationRuleConfiguration> getTypeClass() {
        return SQLFederationRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "SQL_FEDERATION";
    }

    public int getOrder() {
        return 1000;
    }
}

