/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.impl;

import java.util.Collection;
import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DCLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.OracleVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.CreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.DropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.GrantStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dcl.RevokeStatement;

public final class OracleDCLVisitor
extends OracleVisitor
implements DCLVisitor {
    @Override
    public ASTNode visitGrant(OracleStatementParser.GrantContext ctx) {
        GrantStatement result = new GrantStatement();
        if (null != ctx.objectPrivilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.objectPrivilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(OracleStatementParser.RevokeContext ctx) {
        RevokeStatement result = new RevokeStatement();
        if (null != ctx.objectPrivilegeClause()) {
            for (SimpleTableSegment each : this.getTableFromPrivilegeClause(ctx.objectPrivilegeClause())) {
                result.getTables().add(each);
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableFromPrivilegeClause(OracleStatementParser.ObjectPrivilegeClauseContext ctx) {
        return null == ctx.onObjectClause().tableName() ? Collections.emptyList() : Collections.singletonList((SimpleTableSegment)this.visit((ParseTree)ctx.onObjectClause().tableName()));
    }

    @Override
    public ASTNode visitCreateUser(OracleStatementParser.CreateUserContext ctx) {
        return new CreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(OracleStatementParser.DropUserContext ctx) {
        return new DropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(OracleStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(OracleStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(OracleStatementParser.AlterRoleContext ctx) {
        return new AlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(OracleStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement();
    }
}

