/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.struts2.StrutsStatics;

public abstract class StrutsResultSupport
implements Result,
StrutsStatics {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsResultSupport.class);
    public static final String DEFAULT_PARAM = "location";
    public static final String DEFAULT_URL_ENCODING = "UTF-8";
    private boolean parse;
    private boolean encode;
    private String location;
    private String lastFinalLocation;
    protected boolean parseLocation = true;

    public StrutsResultSupport() {
        this(null, true, false);
    }

    public StrutsResultSupport(String location) {
        this(location, true, false);
    }

    public StrutsResultSupport(String location, boolean parse, boolean encode) {
        this.location = location;
        this.parse = parse;
        this.encode = encode;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLastFinalLocation() {
        return this.lastFinalLocation;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        this.lastFinalLocation = this.parseLocation ? this.conditionalParse(this.location, invocation) : this.location;
        this.doExecute(this.lastFinalLocation, invocation);
    }

    protected String conditionalParse(String param, ActionInvocation invocation) {
        if (this.parse && param != null && invocation != null) {
            return TextParseUtil.translateVariables((String)param, (ValueStack)invocation.getStack(), (TextParseUtil.ParsedValueEvaluator)new EncodingParsedValueEvaluator());
        }
        return param;
    }

    protected Collection<String> conditionalParseCollection(String param, ActionInvocation invocation, boolean excludeEmptyElements) {
        if (this.parse && param != null && invocation != null) {
            return TextParseUtil.translateVariablesCollection((String)param, (ValueStack)invocation.getStack(), (boolean)excludeEmptyElements, (TextParseUtil.ParsedValueEvaluator)new EncodingParsedValueEvaluator());
        }
        ArrayList<String> collection = new ArrayList<String>(1);
        collection.add(param);
        return collection;
    }

    protected abstract void doExecute(String var1, ActionInvocation var2) throws Exception;

    private final class EncodingParsedValueEvaluator
    implements TextParseUtil.ParsedValueEvaluator {
        private EncodingParsedValueEvaluator() {
        }

        public Object evaluate(String parsedValue) {
            block3: {
                if (StrutsResultSupport.this.encode && parsedValue != null) {
                    try {
                        return URLEncoder.encode(parsedValue, StrutsResultSupport.DEFAULT_URL_ENCODING);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!LOG.isWarnEnabled()) break block3;
                        LOG.warn("error while trying to encode [" + parsedValue + "]", (Throwable)e, new String[0]);
                    }
                }
            }
            return parsedValue;
        }
    }
}

