/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import org.beangle.commons.dao.Dao;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;

public abstract class GenericDao<T extends Entity<ID>, ID extends Serializable>
implements Dao<T, ID> {
    protected EntityDao entityDao;
    protected Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public T get(ID id) {
        return this.entityDao.get(this.getEntityClass(), id);
    }

    @Override
    public List<T> get(ID[] ids) {
        OqlBuilder<T> query = OqlBuilder.from(this.getEntityClass(), "entity").where(new Condition("entity.id in(:gids)", ids));
        return this.entityDao.search(query);
    }

    @Override
    public void saveOrUpdate(T entity) {
        this.entityDao.saveOrUpdate(entity);
    }

    @Override
    public void saveOrUpdate(Collection<T> entitis) {
        this.entityDao.saveOrUpdate(entitis);
    }

    @Override
    public void remove(Collection<T> entitis) {
        this.entityDao.remove(entitis);
    }

    @Override
    public void remove(T entity) {
        this.entityDao.remove(entity);
    }

    @Override
    public void remove(ID id) {
        this.entityDao.remove(this.get(id));
    }

    @Override
    public void remove(ID[] ids) {
        this.entityDao.remove((Collection<?>)this.get((ID)ids));
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityDao(EntityDao entityDao) {
        this.entityDao = entityDao;
    }
}

