/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.impl.BaseServiceImpl;
import org.beangle.commons.entity.HierarchyEntity;
import org.beangle.commons.entity.pojo.NumberIdHierarchyObject;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;

public abstract class AbstractHierarchyService<T extends NumberIdHierarchyObject<? super T, ?>>
extends BaseServiceImpl {
    public void move(T node, T location, int index) {
        if (Objects.equals(((NumberIdHierarchyObject)node).getParent(), location)) {
            if (Numbers.toInt((String)((NumberIdHierarchyObject)node).getIndexno()) != index) {
                this.shiftCode(node, location, index);
            }
        } else {
            if (null != ((NumberIdHierarchyObject)node).getParent()) {
                ((HierarchyEntity)((NumberIdHierarchyObject)node).getParent()).getChildren().remove(node);
            }
            ((NumberIdHierarchyObject)node).setParent(location);
            this.shiftCode(node, location, index);
        }
    }

    private void shiftCode(T node, T newParent, int index) {
        List sibling = null;
        if (null != newParent) {
            sibling = ((NumberIdHierarchyObject)newParent).getChildren();
        } else {
            sibling = CollectUtils.newArrayList();
            for (NumberIdHierarchyObject m : this.getTopNodes(node)) {
                if (null != m.getParent()) continue;
                sibling.add(m);
            }
        }
        Collections.sort(sibling);
        sibling.remove(node);
        if (--index > sibling.size()) {
            index = sibling.size();
        }
        sibling.add(index, node);
        int nolength = String.valueOf(sibling.size()).length();
        Set nodes = CollectUtils.newHashSet();
        for (int seqno = 1; seqno <= sibling.size(); ++seqno) {
            NumberIdHierarchyObject one = (NumberIdHierarchyObject)sibling.get(seqno - 1);
            this.generateCode(one, Strings.leftPad((String)String.valueOf(seqno), (int)nolength, (char)'0'), nodes);
        }
        this.entityDao.saveOrUpdate(nodes);
    }

    protected abstract List<T> getTopNodes(T var1);

    private void generateCode(T node, String indexno, Set<T> nodes) {
        nodes.add(node);
        if (null != indexno) {
            ((NumberIdHierarchyObject)node).genIndexno(indexno);
        } else {
            ((NumberIdHierarchyObject)node).genIndexno();
        }
        if (null != ((NumberIdHierarchyObject)node).getChildren()) {
            for (Object m : ((NumberIdHierarchyObject)node).getChildren()) {
                this.generateCode((NumberIdHierarchyObject)m, null, nodes);
            }
        }
    }
}

