/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.lang.Strings;

public class Condition {
    private final String content;
    private final List<Object> params = new ArrayList<Object>(1);

    public Condition(String content) {
        this.content = content;
    }

    public Condition(String content, Object param1) {
        this.content = content;
        this.params.add(param1);
    }

    public Condition(String content, Object param1, Object param2) {
        this(content, param1, param2, null);
    }

    public Condition(String content, Object param1, Object param2, Object param3) {
        this.content = content;
        if (null != param1) {
            this.params.add(param1);
        }
        if (null != param2) {
            this.params.add(param2);
        }
        if (null != param3) {
            this.params.add(param3);
        }
    }

    public String getContent() {
        return this.content;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public boolean isNamed() {
        return !Strings.contains((CharSequence)this.content, (CharSequence)"?");
    }

    public List<String> getParamNames() {
        int colonIndex;
        if (!Strings.contains((CharSequence)this.content, (CharSequence)":")) {
            return Collections.emptyList();
        }
        ArrayList<String> params = new ArrayList<String>();
        int index = 0;
        while (-1 != (colonIndex = this.content.indexOf(58, index))) {
            char c;
            for (index = colonIndex + 1; index < this.content.length() && Condition.isValidIdentifierStarter(c = this.content.charAt(index)); ++index) {
            }
            String paramName = this.content.substring(colonIndex + 1, index);
            if (!params.contains(paramName)) {
                params.add(paramName);
            }
            if (index < this.content.length()) continue;
        }
        return params;
    }

    private static boolean isValidIdentifierStarter(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_' || '0' <= ch && ch <= '9';
    }

    public Condition param(Object value) {
        this.params.add(value);
        return this;
    }

    public Condition params(List<?> values) {
        this.params.clear();
        this.params.addAll(values);
        return this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.content).append(" ");
        for (Object value : this.params) {
            str.append(value);
        }
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (null == this.getContent() || !(obj instanceof Condition)) {
            return false;
        }
        return this.getContent().equals(((Condition)obj).getContent());
    }

    public int hashCode() {
        if (null == this.content) {
            return 0;
        }
        return this.content.hashCode();
    }

    public static Condition eq(String content, Number value) {
        return new Condition(content + " = " + value);
    }

    public static Condition eq(String content, String value) {
        int attrIndex = content.lastIndexOf(46);
        String paramName = ":" + (attrIndex == -1 ? content + System.currentTimeMillis() : content.substring(attrIndex + 1) + System.currentTimeMillis());
        return new Condition(content + " = " + paramName, value);
    }

    public static Condition le(String content, Number value) {
        return new Condition(content + " <= " + value);
    }

    public static Condition ge(String content, Number value) {
        return new Condition(content + " >= " + value);
    }

    public static Condition ne(String content, Number value) {
        return new Condition(content + " <> " + value);
    }

    public static Condition like(String content, String value) {
        int attrIndex = content.lastIndexOf(46);
        String paramName = ":" + (attrIndex == -1 ? content + System.currentTimeMillis() : content.substring(attrIndex + 1) + System.currentTimeMillis());
        return new Condition(content + " like " + paramName, "%" + value + "%");
    }
}

