/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.Lang;
import org.beangle.commons.dao.query.builder.AbstractQueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.entity.util.EntityUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;

public class OqlBuilder<T>
extends AbstractQueryBuilder<T> {
    protected Class<T> entityClass;

    protected OqlBuilder() {
    }

    public static <E> OqlBuilder<E> hql(String hql) {
        OqlBuilder query = new OqlBuilder();
        query.statement = hql;
        return query;
    }

    public static <E> OqlBuilder<E> from(String from) {
        OqlBuilder query = new OqlBuilder();
        query.newFrom(from);
        return query;
    }

    public static <E> OqlBuilder<E> from(String entityName, String alias) {
        EntityType type = Model.getType(entityName);
        OqlBuilder query = new OqlBuilder();
        if (null != type) {
            query.entityClass = type.getEntityClass();
        }
        query.alias = alias;
        query.select = "select " + alias;
        query.from = Strings.concat((String[])new String[]{"from ", entityName, " ", alias});
        return query;
    }

    public static <E> OqlBuilder<E> from(Class<E> entityClass) {
        EntityType type = Model.getType(entityClass.getName());
        if (null == type) {
            type = Model.getType(entityClass);
        }
        return OqlBuilder.from(entityClass, EntityUtils.getCommandName(type.getEntityName()));
    }

    public static <E> OqlBuilder<E> from(Class<E> entityClass, String alias) {
        EntityType type = Model.getType(entityClass.getName());
        if (null == type) {
            type = Model.getType(entityClass);
        }
        OqlBuilder query = new OqlBuilder();
        query.entityClass = type.getEntityClass();
        query.alias = alias;
        query.select = "select " + alias;
        query.from = Strings.concat((String[])new String[]{"from ", type.getEntityName(), " ", alias});
        return query;
    }

    public OqlBuilder<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    public OqlBuilder<T> join(String path, String alias) {
        this.from = Strings.concat((String[])new String[]{this.from, " join ", path, " ", alias});
        return this;
    }

    public OqlBuilder<T> join(String joinMode, String path, String alias) {
        this.from = Strings.concat((String[])new String[]{this.from, " ", joinMode, " join ", path, " ", alias});
        return this;
    }

    @Override
    public OqlBuilder<T> params(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public OqlBuilder<T> param(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    @Override
    public OqlBuilder<T> limit(PageLimit limit) {
        this.limit = limit;
        return this;
    }

    public OqlBuilder<T> limit(int pageNo, int pageSize) {
        this.limit = new PageLimit(pageNo, pageSize);
        return this;
    }

    public OqlBuilder<T> cacheable() {
        this.cacheable = true;
        return this;
    }

    public OqlBuilder<T> cacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public OqlBuilder<T> where(Condition ... conditions) {
        if (Strings.isNotEmpty((CharSequence)this.statement)) {
            throw new RuntimeException("cannot add condition to a exists statement");
        }
        return this.where(Arrays.asList(conditions));
    }

    public OqlBuilder<T> where(String content) {
        Condition con = new Condition(content);
        return this.where(con);
    }

    public OqlBuilder<T> where(String content, Object param1) {
        Condition con = new Condition(content);
        con.param(param1);
        return this.where(con);
    }

    public OqlBuilder<T> where(String content, Object param1, Object param2) {
        Condition con = new Condition(content);
        con.param(param1);
        con.param(param2);
        return this.where(con);
    }

    public OqlBuilder<T> where(String content, Object param1, Object param2, Object param3, Object ... varparams) {
        Condition con = new Condition(content);
        con.param(param1);
        con.param(param2);
        con.param(param3);
        if (varparams != null && varparams.length > 0) {
            for (Object a : varparams) {
                con.param(a);
            }
        }
        return this.where(con);
    }

    public OqlBuilder<T> where(Collection<Condition> cons) {
        this.conditions.addAll(cons);
        return this.params((Map)Conditions.getParamMap(cons));
    }

    public OqlBuilder<T> orderBy(String orderBy) {
        return this.orderBy(Order.parse((String)orderBy));
    }

    public OqlBuilder<T> orderBy(int index, String orderBy) {
        if (null != this.orders) {
            if (Strings.isNotEmpty((CharSequence)this.statement)) {
                throw new RuntimeException("cannot add order by to a exists statement.");
            }
            this.orders.addAll(index, Order.parse((String)orderBy));
        }
        return this;
    }

    public OqlBuilder<T> orderBy(Order order) {
        if (null != order) {
            return this.orderBy(Collections.singletonList(order));
        }
        return this;
    }

    public OqlBuilder<T> clearOrders() {
        this.orders.clear();
        return this;
    }

    public OqlBuilder<T> orderBy(List<Order> orders) {
        if (null != orders) {
            if (Strings.isNotEmpty((CharSequence)this.statement)) {
                throw new RuntimeException("cannot add order by to a exists statement.");
            }
            this.orders.addAll(orders);
        }
        return this;
    }

    public OqlBuilder<T> select(String what) {
        this.select = null == what ? null : (what.toLowerCase().trim().startsWith("select") ? what : "select " + what);
        return this;
    }

    public OqlBuilder<T> newFrom(String from) {
        this.from = null == from ? null : (Strings.contains((CharSequence)from.toLowerCase(), (CharSequence)"from") ? from : "from " + from);
        return this;
    }

    public OqlBuilder<T> groupBy(String what) {
        if (Strings.isNotEmpty((CharSequence)what)) {
            this.groups.add(what);
        }
        return this;
    }

    public OqlBuilder<T> having(String what) {
        Assert.isTrue((null != this.groups && !this.groups.isEmpty() ? 1 : 0) != 0);
        if (Strings.isNotEmpty((CharSequence)what)) {
            this.having = what;
        }
        return this;
    }

    @Override
    protected String genCountStatement() {
        int orderIdx;
        StringBuilder countString = new StringBuilder("select count(*) ");
        String genQueryStr = this.genQueryStatement(false);
        if (Strings.isEmpty((CharSequence)genQueryStr)) {
            return "";
        }
        String lowerCaseQueryStr = genQueryStr.toLowerCase();
        if (Strings.contains((CharSequence)lowerCaseQueryStr, (CharSequence)" group ")) {
            return "";
        }
        if (Strings.contains((CharSequence)lowerCaseQueryStr, (CharSequence)" union ")) {
            return "";
        }
        int indexOfFrom = this.findIndexOfFrom(lowerCaseQueryStr);
        String selectWhat = lowerCaseQueryStr.substring(0, indexOfFrom);
        int indexOfDistinct = selectWhat.indexOf("distinct");
        if (-1 != indexOfDistinct) {
            if (Strings.contains((CharSequence)selectWhat, (CharSequence)",")) {
                return "";
            }
            countString = new StringBuilder("select count(");
            countString.append(genQueryStr.substring(indexOfDistinct, indexOfFrom)).append(") ");
        }
        if (-1 == (orderIdx = genQueryStr.lastIndexOf(" order "))) {
            orderIdx = genQueryStr.length();
        }
        countString.append(genQueryStr.substring(indexOfFrom, orderIdx));
        return countString.toString();
    }

    private int findIndexOfFrom(String query) {
        if (query.startsWith("from")) {
            return 0;
        }
        int fromIdx = query.indexOf(" from ");
        if (-1 == fromIdx) {
            return -1;
        }
        int first = query.substring(0, fromIdx).indexOf("(");
        if (first > 0) {
            int i;
            int leftCnt = 1;
            for (i = first + 1; leftCnt != 0 && i < query.length(); ++i) {
                if (query.charAt(i) == '(') {
                    ++leftCnt;
                    continue;
                }
                if (query.charAt(i) != ')') continue;
                --leftCnt;
            }
            if (leftCnt > 0) {
                return -1;
            }
            fromIdx = query.indexOf(" from ", i);
            return fromIdx == -1 ? -1 : fromIdx + 1;
        }
        return fromIdx + 1;
    }

    public OqlBuilder<T> forEntity(Class<T> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    @Override
    protected Lang getLang() {
        return Lang.HQL;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

