/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.Order;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.dao.query.Lang;
import org.beangle.commons.dao.query.builder.AbstractQueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.Conditions;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;

public class SqlBuilder
extends AbstractQueryBuilder<Object[]> {
    public static SqlBuilder sql(String queryStr) {
        SqlBuilder sqlQuery = new SqlBuilder();
        sqlQuery.statement = queryStr;
        return sqlQuery;
    }

    @Override
    protected String genCountStatement() {
        return "select count(*) from (" + this.genQueryStatement(false) + ")";
    }

    @Override
    protected Lang getLang() {
        return Lang.SQL;
    }

    public SqlBuilder alias(String alias) {
        this.alias = alias;
        return this;
    }

    public SqlBuilder join(String path, String alias) {
        this.from = this.from + " join " + path + " " + alias;
        return this;
    }

    public SqlBuilder join(String joinMode, String path, String alias) {
        this.from = this.from + " " + joinMode + " join " + path + " " + alias;
        return this;
    }

    public SqlBuilder params(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public SqlBuilder param(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public SqlBuilder limit(PageLimit limit) {
        this.limit = limit;
        return this;
    }

    public SqlBuilder limit(int pageNo, int pageSize) {
        this.limit = new PageLimit(pageNo, pageSize);
        return this;
    }

    public SqlBuilder cacheable() {
        this.cacheable = true;
        return this;
    }

    public SqlBuilder cacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public SqlBuilder where(Condition ... cons) {
        if (Strings.isNotEmpty((CharSequence)this.statement)) {
            throw new RuntimeException("cannot add condition to a exists statement");
        }
        return this.where(Arrays.asList(cons));
    }

    public SqlBuilder where(String content, Object ... varparams) {
        Condition con = new Condition(content);
        con.params(Arrays.asList(varparams));
        return this.where(con);
    }

    public SqlBuilder where(Collection<Condition> cons) {
        this.conditions.addAll(cons);
        return this.params((Map)Conditions.getParamMap(cons));
    }

    public SqlBuilder orderBy(String orderBy) {
        this.orders.addAll(Order.parse((String)orderBy));
        return this;
    }

    public SqlBuilder orderBy(Order order) {
        if (null != order) {
            this.orders.add(order);
        }
        return this;
    }

    public SqlBuilder clearOrders() {
        this.orders.clear();
        return this;
    }

    public SqlBuilder orderBy(List<Order> orders) {
        if (null != orders) {
            this.orders.addAll(orders);
        }
        return this;
    }

    public SqlBuilder select(String what) {
        this.select = null == what ? null : (Strings.contains((CharSequence)what.toLowerCase(), (CharSequence)"select") ? what : "select " + what);
        return this;
    }

    public SqlBuilder newFrom(String from) {
        this.from = null == from ? null : (Strings.contains((CharSequence)from.toLowerCase(), (CharSequence)"from") ? from : " from " + from);
        return this;
    }

    public SqlBuilder groupBy(String what) {
        if (Strings.isNotEmpty((CharSequence)what)) {
            this.groups.add(what);
        }
        return this;
    }

    public SqlBuilder having(String what) {
        Assert.isTrue((null != this.groups && !this.groups.isEmpty() ? 1 : 0) != 0);
        if (Strings.isNotEmpty((CharSequence)what)) {
            this.having = what;
        }
        return this;
    }
}

