/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.dao.query.limit;

import java.util.Iterator;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.PageWapper;
import org.beangle.commons.collection.page.SinglePage;
import org.beangle.commons.dao.query.LimitQuery;
import org.beangle.commons.dao.query.limit.PageIterator;

public abstract class AbstractQueryPage<T>
extends PageWapper<T> {
    protected int pageNo = 0;
    protected int maxPageNo = 0;
    protected LimitQuery<T> query;

    public abstract Page<T> moveTo(int var1);

    public AbstractQueryPage() {
    }

    public AbstractQueryPage(LimitQuery<T> query) {
        this.query = query;
        if (null != query) {
            if (null == query.getLimit()) {
                query.limit(new PageLimit(this.pageNo, 20));
            } else {
                this.pageNo = query.getLimit().getPageNo() - 1;
            }
        }
    }

    protected void setPageData(SinglePage<T> page) {
        this.setPage((Page)page);
        this.pageNo = page.getPageNo();
        this.maxPageNo = page.getMaxPageNo();
    }

    public Page<T> next() {
        return this.moveTo(this.pageNo + 1);
    }

    public Page<T> previous() {
        return this.moveTo(this.pageNo - 1);
    }

    public boolean hasNext() {
        return this.maxPageNo > this.pageNo;
    }

    public boolean hasPrevious() {
        return this.pageNo > 1;
    }

    public int getFirstPageNo() {
        return 1;
    }

    public int getMaxPageNo() {
        return this.maxPageNo;
    }

    public int getNextPageNo() {
        return this.getPage().getNextPageNo();
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.query.getLimit().getPageSize();
    }

    public int getPreviousPageNo() {
        return this.getPage().getPreviousPageNo();
    }

    public int getTotal() {
        return this.getPage().getTotal();
    }

    public Iterator<T> iterator() {
        return new PageIterator(this);
    }
}

