/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.comment;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.beangle.commons.lang.Strings;

public class Generator {
    private static String dir;
    private static OutputStreamWriter writer;
    private static OutputStreamWriter localeWriter;

    public static boolean start(RootDoc root) throws Exception {
        String userdir = System.getProperty("user.dir");
        dir = Strings.substringBefore((String)userdir, (String)"/site/apidocs") + "/comment/";
        System.out.println("Entity comments will be generated in " + dir);
        Locale locale = Locale.getDefault();
        for (ClassDoc classDoc : root.classes()) {
            String tableComment;
            if (!Generator.isAnnotationPresent((ProgramElementDoc)classDoc, Entity.class, MappedSuperclass.class, Embeddable.class)) continue;
            String className = classDoc.qualifiedTypeName();
            String packageName = Strings.substringBeforeLast((String)className, (String)".") + ".package";
            String shortName = Strings.substringAfterLast((String)className, (String)".");
            File file = new File(dir + Strings.replace((String)packageName, (String)".", (String)"/") + ".en_US");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "utf-8");
            if (!locale.toString().equals("en_US")) {
                File localeFile = new File(dir + Strings.replace((String)packageName, (String)".", (String)"/") + "." + locale);
                localeWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(localeFile, true), "utf-8");
                if (!localeFile.exists()) {
                    localeFile.getParentFile().mkdirs();
                    localeFile.createNewFile();
                }
            }
            if (Strings.isNotBlank((CharSequence)(tableComment = classDoc.commentText()))) {
                Generator.comment(shortName, Strings.split((String)tableComment, (String)"\n")[0]);
            } else {
                Generator.missingComment(shortName);
            }
            for (FieldDoc fieldDoc : classDoc.fields(false)) {
                if (fieldDoc.isTransient() || fieldDoc.isStatic()) continue;
                String fieldName = fieldDoc.name();
                String fieldComment = fieldDoc.commentText();
                if (Strings.isBlank((CharSequence)fieldComment)) {
                    Generator.missingComment(shortName + "." + fieldDoc.name());
                    continue;
                }
                fieldComment = Strings.split((String)fieldComment, (String)"\n")[0];
                Generator.comment(shortName, fieldName, fieldComment);
            }
            writer.close();
            if (null == localeWriter) continue;
            localeWriter.close();
        }
        return true;
    }

    private static String uncamel(String name) {
        String[] names = Strings.split((String)Strings.unCamel((String)name, (char)' '), (char)' ');
        for (int i = 0; i < names.length; ++i) {
            names[i] = Strings.capitalize((String)names[i]);
        }
        return Strings.join((String[])names, (String)" ");
    }

    private static boolean isAnnotationPresent(ProgramElementDoc doc, Class<?> ... types) {
        for (AnnotationDesc ad : doc.annotations()) {
            for (Class<?> type : types) {
                if (!ad.annotationType().qualifiedTypeName().equals(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void comment(String shortName, String comment) throws IOException {
        String newComment = Strings.replace((String)comment, (String)"<br>", (String)"");
        writer.append("\n" + shortName + "=" + Generator.uncamel(Strings.replace((String)shortName, (String)"Bean", (String)"")) + "\n");
        if (null != localeWriter) {
            localeWriter.append("\n" + shortName + "=" + newComment + "\n");
        }
    }

    private static void comment(String shortName, String columnName, String comment) throws IOException {
        String newComment = Strings.replace((String)comment, (String)"<br>", (String)"");
        writer.append(shortName + "." + columnName + "=" + Generator.uncamel(columnName) + "\n");
        if (null != localeWriter) {
            localeWriter.append(shortName + "." + columnName + "=" + newComment + "\n");
        }
    }

    private static void missingComment(String shortName) throws IOException {
        writer.append("\n##missing  " + shortName + "\n");
        if (null != localeWriter) {
            localeWriter.append("\n##missing  " + shortName + "\n");
        }
    }

    public static int optionLength(String option) {
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return true;
    }
}

