/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata;

import java.util.Map;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.AbstractType;
import org.beangle.commons.entity.metadata.IdentifierType;
import org.beangle.commons.entity.metadata.Type;

public class ComponentType
extends AbstractType {
    private Class<?> componentClass;
    private final Map<String, Type> propertyTypes = CollectUtils.newHashMap();

    @Override
    public boolean isComponentType() {
        return true;
    }

    @Override
    public String getName() {
        return this.componentClass.toString();
    }

    @Override
    public Class<?> getReturnedClass() {
        return this.componentClass;
    }

    public ComponentType() {
    }

    public ComponentType(Class<?> componentClass) {
        this.componentClass = componentClass;
    }

    @Override
    public Type getPropertyType(String propertyName) {
        Class propertyType;
        Type type = this.propertyTypes.get(propertyName);
        if (null == type && null != (propertyType = PropertyUtils.getPropertyType(this.componentClass, (String)propertyName))) {
            return new IdentifierType(propertyType);
        }
        return type;
    }

    public Map<String, Type> getPropertyTypes() {
        return this.propertyTypes;
    }
}

