/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata;

import java.io.Serializable;
import java.util.Map;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.AbstractType;
import org.beangle.commons.entity.metadata.IdentifierType;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.entity.metadata.Type;
import org.beangle.commons.lang.Assert;

public class EntityType
extends AbstractType {
    private String entityName;
    private Class<?> entityClass;
    private Map<String, Type> propertyTypes = CollectUtils.newHashMap();
    private String idName;

    public EntityType(String entityName, Class<?> entityClass, String idName) {
        Assert.notNull((Object)idName);
        Assert.notNull((Object)entityName);
        Assert.notNull(entityClass);
        this.entityName = entityName;
        this.entityClass = entityClass;
        this.idName = idName;
        Class clazz = PropertyUtils.getPropertyType(entityClass, (String)idName);
        if (null != clazz) {
            this.propertyTypes.put(idName, new IdentifierType(clazz));
        }
    }

    public EntityType(String entityName, Class<?> entityClass, String idName, Type idType) {
        Assert.notNull((Object)idName);
        Assert.notNull((Object)entityName);
        Assert.notNull(entityClass);
        this.entityName = entityName;
        this.entityClass = entityClass;
        this.idName = idName;
        this.propertyTypes.put(idName, idType);
    }

    public EntityType(Class<?> entityClass) {
        this(entityClass.getName(), entityClass, "id");
    }

    @Override
    public boolean isEntityType() {
        return true;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Map<String, Type> getPropertyTypes() {
        return this.propertyTypes;
    }

    public void setPropertyTypes(Map<String, Type> propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Override
    public Type getPropertyType(String property) {
        Class propertyType;
        Type type = this.propertyTypes.get(property);
        if (null == type && null != (propertyType = PropertyUtils.getPropertyType(this.entityClass, (String)property))) {
            if (Entity.class.isAssignableFrom(propertyType)) {
                type = new EntityType(propertyType);
            }
            if (propertyType.isInterface()) {
                type = Model.getType(propertyType.getName());
            }
            if (null == type) {
                type = new IdentifierType(propertyType);
            }
        }
        if (null == type) {
            logger.error("{} doesn't contains property {}", (Object)this.entityName, (Object)property);
        }
        return type;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public Class<?> getReturnedClass() {
        return this.entityClass;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public Class<? extends Serializable> getIdType() {
        Type type = this.propertyTypes.get(this.idName);
        return null != type ? type.getReturnedClass() : null;
    }
}

