/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata.impl;

import java.util.List;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.EntityContext;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.IdentifierType;
import org.beangle.commons.entity.metadata.Type;
import org.beangle.commons.lang.ClassLoaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityContext
implements EntityContext {
    protected Map<String, EntityType> entityTypes = CollectUtils.newHashMap();
    protected Map<String, EntityType> classEntityTypes = CollectUtils.newHashMap();
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEntityContext.class);

    @Override
    public String[] getEntityNames(Class<?> clazz) {
        return new String[0];
    }

    @Override
    public Type getType(String name) {
        EntityType type = this.getEntityType(name);
        if (null == type) {
            try {
                return new IdentifierType(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                logger.error("system doesn't contains entity {}", (Object)name);
                return null;
            }
        }
        return type;
    }

    @Override
    public String getEntityName(Object obj) {
        EntityType type = this.getEntityType(obj.getClass());
        if (null != type) {
            return type.getEntityName();
        }
        return null;
    }

    @Override
    public EntityType getEntityType(Class<?> entityClass) {
        String className = entityClass.getName();
        EntityType type = this.entityTypes.get(className);
        if (null != type) {
            return type;
        }
        type = this.classEntityTypes.get(className);
        if (null == type) {
            List matched = CollectUtils.newArrayList();
            for (EntityType entityType : this.entityTypes.values()) {
                if (!className.equals(entityType.getEntityName()) && !className.equals(entityType.getEntityClass().getName())) continue;
                matched.add(entityType);
            }
            if (matched.size() > 1) {
                throw new RuntimeException("multi-entityName for class:" + className);
            }
            if (matched.isEmpty()) {
                EntityType tmp = new EntityType(entityClass);
                this.classEntityTypes.put(className, tmp);
                return tmp;
            }
            this.classEntityTypes.put(className, (EntityType)matched.get(0));
            type = (EntityType)matched.get(0);
        }
        return type;
    }

    @Override
    public EntityType getEntityType(String entityName) {
        EntityType type = this.entityTypes.get(entityName);
        if (null != type) {
            return type;
        }
        type = this.classEntityTypes.get(entityName);
        if (null == type) {
            try {
                Class entityClass = ClassLoaders.loadClass((String)entityName);
                if (Entity.class.isAssignableFrom(entityClass)) {
                    type = new EntityType(entityClass);
                } else {
                    logger.warn("{} 's is not entity", (Object)entityClass);
                }
            }
            catch (Exception e) {
                logger.error("system doesn't contains entity {}", (Object)entityName);
            }
        }
        return type;
    }
}

