/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata.impl;

import java.util.Map;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.conversion.Conversion;
import org.beangle.commons.conversion.impl.DefaultConversion;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.ObjectAndType;
import org.beangle.commons.entity.metadata.Populator;
import org.beangle.commons.entity.metadata.Type;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertPopulatorBean
implements Populator {
    protected static final Logger logger = LoggerFactory.getLogger(ConvertPopulatorBean.class);
    public static final boolean TRIM_STR = true;
    private Conversion conversion;

    public ConvertPopulatorBean() {
        this((Conversion)DefaultConversion.Instance);
    }

    public ConvertPopulatorBean(Conversion conversion) {
        this.conversion = conversion;
    }

    @Override
    public ObjectAndType initProperty(Object target, Type type, String attr) {
        Object propObj = target;
        Object property = null;
        String[] attrs = Strings.split((String)attr, (String)".");
        for (int index = 0; index < attrs.length; ++index) {
            try {
                property = PropertyUtils.getProperty((Object)propObj, (String)attrs[index]);
                Type propertyType = type.getPropertyType(attrs[index]);
                if (null == propertyType) {
                    logger.error("Cannot find property type [{}] of {}", (Object)attrs[index], propObj.getClass());
                    throw new RuntimeException("Cannot find property type " + attrs[index] + " of " + propObj.getClass().getName());
                }
                if (null == property) {
                    property = propertyType.newInstance();
                    PropertyUtils.setProperty((Object)propObj, (String)attrs[index], (Object)property);
                }
                propObj = property;
                type = propertyType;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new ObjectAndType(property, type);
    }

    @Override
    public boolean populateValue(Object target, EntityType type, String attr, Object value) {
        try {
            if (attr.indexOf(46) > -1) {
                ObjectAndType ot = this.initProperty(target, type, Strings.substringBeforeLast((String)attr, (String)"."));
                String lastAttr = Strings.substringAfterLast((String)attr, (String)".");
                PropertyUtils.setProperty((Object)ot.getObj(), (String)lastAttr, (Object)this.convert(ot.getType(), lastAttr, value));
            } else {
                PropertyUtils.setProperty((Object)target, (String)attr, (Object)this.convert(type, attr, value));
            }
            return true;
        }
        catch (Exception e) {
            logger.warn("copy property failure:[class:" + type.getEntityName() + " attr:" + attr + " value:" + value + "]:", (Throwable)e);
            return false;
        }
    }

    @Override
    public Object populate(Object entity, EntityType type, Map<String, Object> params) {
        for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
            String attr = paramEntry.getKey();
            Object value = paramEntry.getValue();
            if (value instanceof String) {
                value = Strings.isEmpty((CharSequence)((String)value)) ? null : ((String)value).trim();
            }
            if (-1 == attr.indexOf(46)) {
                this.copyValue(entity, attr, value);
                continue;
            }
            String parentAttr = Strings.substring((String)attr, (int)0, (int)attr.lastIndexOf(46));
            try {
                ObjectAndType ot = this.initProperty(entity, type, parentAttr);
                if (null == ot) {
                    logger.error("error attr:[" + attr + "] value:[" + value + "]");
                    continue;
                }
                if (ot.getType().isEntityType()) {
                    String foreignKey = ((EntityType)ot.getType()).getIdName();
                    if (attr.endsWith("." + foreignKey)) {
                        Object newValue;
                        if (null == value) {
                            this.copyValue(entity, parentAttr, null);
                            continue;
                        }
                        Object oldValue = PropertyUtils.getProperty((Object)entity, (String)attr);
                        if (Objects.equals((Object)oldValue, (Object)(newValue = this.convert(ot.getType(), foreignKey, value)))) continue;
                        if (null != oldValue) {
                            this.copyValue(entity, parentAttr, null);
                            this.initProperty(entity, type, parentAttr);
                        }
                        PropertyUtils.setProperty((Object)entity, (String)attr, (Object)newValue);
                        continue;
                    }
                    this.copyValue(entity, attr, value);
                    continue;
                }
                this.copyValue(entity, attr, value);
            }
            catch (Exception e) {
                logger.error("error attr:[" + attr + "] value:[" + value + "]", (Throwable)e);
            }
        }
        return entity;
    }

    private Object convert(Type type, String attr, Object value) {
        Object attrValue = null;
        if (null != value) {
            attrValue = this.conversion.convert(value, type.getPropertyType(attr).getReturnedClass());
        }
        return attrValue;
    }

    private Object copyValue(Object target, String attr, Object value) {
        return PropertyUtils.copyProperty((Object)target, (String)attr, (Object)value, (Conversion)this.conversion);
    }
}

