/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.metadata.impl;

import java.io.Serializable;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.EntityContext;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.ModelMeta;
import org.beangle.commons.entity.metadata.Populator;
import org.beangle.commons.entity.metadata.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelMeta
implements ModelMeta {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModelMeta.class);
    protected EntityContext context;
    protected Populator populator;

    @Override
    public <T extends Entity<?>> T newInstance(Class<T> clazz) {
        return (T)((Entity)this.getEntityType(clazz).newInstance());
    }

    @Override
    public <T extends Entity<ID>, ID extends Serializable> T newInstance(Class<T> clazz, ID id) {
        EntityType type = this.getEntityType(clazz);
        Entity entity = (Entity)type.newInstance();
        try {
            PropertyUtils.setProperty((Object)entity, (String)type.getIdName(), id);
        }
        catch (Exception e) {
            logger.error("initialize {} with id {} error", clazz, id);
        }
        return (T)entity;
    }

    @Override
    public EntityType getEntityType(String entityName) {
        return this.context.getEntityType(entityName);
    }

    @Override
    public Type getType(String entityName) {
        return this.context.getType(entityName);
    }

    @Override
    public String getEntityName(Object obj) {
        return this.context.getEntityName(obj);
    }

    @Override
    public EntityType getEntityType(Class<?> clazz) {
        EntityType type = this.context.getEntityType(clazz);
        if (null == type) {
            type = new EntityType(clazz);
        }
        return type;
    }

    public void setContext(EntityContext context) {
        this.context = context;
    }

    public void setPopulator(Populator populator) {
        this.populator = populator;
    }

    @Override
    public Populator getPopulator() {
        return this.populator;
    }
}

