/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.orm;

import java.util.Collection;
import java.util.Map;
import javax.persistence.Entity;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;

public final class EntityPersistConfig {
    final Map<String, EntityDefinition> entities = CollectUtils.newHashMap();
    final Map<String, CollectionDefinition> collections = CollectUtils.newHashMap();
    final CacheConfig cache = new CacheConfig();

    public Collection<EntityDefinition> getEntites() {
        return this.entities.values();
    }

    public Collection<CollectionDefinition> getCollections() {
        return this.collections.values();
    }

    public EntityDefinition getEntity(Class<?> clazz) {
        return this.entities.get(clazz.getName());
    }

    public EntityPersistConfig addEntity(EntityDefinition definition) {
        this.entities.put(definition.getClazz().getName(), definition);
        return this;
    }

    public EntityPersistConfig addCollection(CollectionDefinition definition) {
        this.collections.put(definition.getClazz().getName() + definition.property, definition);
        return this;
    }

    public CacheConfig getCache() {
        return this.cache;
    }

    public static final class CacheConfig {
        String region;
        String usage;

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getUsage() {
            return this.usage;
        }

        public void setUsage(String usage) {
            this.usage = usage;
        }
    }

    public static final class EntityDefinition {
        final Class<?> clazz;
        final String entityName;
        String cacheUsage;
        String cacheRegion;

        public EntityDefinition(Class<?> clazz) {
            this.clazz = clazz;
            Entity annotation = clazz.getAnnotation(Entity.class);
            Assert.notNull((Object)annotation);
            this.entityName = Strings.isNotBlank((CharSequence)annotation.name()) ? annotation.name() : clazz.getName();
        }

        public void cache(String region, String usage) {
            this.cacheRegion = region;
            this.cacheUsage = usage;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getCacheUsage() {
            return this.cacheUsage;
        }

        public void setCacheUsage(String cacheUsage) {
            this.cacheUsage = cacheUsage;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public void setCacheRegion(String cacheRegion) {
            this.cacheRegion = cacheRegion;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public boolean equals(Object obj) {
            return this.clazz.equals(obj);
        }
    }

    public static final class CollectionDefinition {
        final Class<?> clazz;
        final String property;
        String cacheRegion;
        String cacheUsage;

        public CollectionDefinition(Class<?> clazz, String property) {
            this.clazz = clazz;
            this.property = property;
        }

        public CollectionDefinition cache(String region, String usage) {
            this.cacheRegion = region;
            this.cacheUsage = usage;
            return this;
        }

        public String getProperty() {
            return this.property;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getCacheUsage() {
            return this.cacheUsage;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }
    }
}

