/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.entity.util;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.TemporalAt;
import org.beangle.commons.entity.TemporalOn;
import org.beangle.commons.lang.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(EntityUtils.class);

    private EntityUtils() {
    }

    public static <T extends Entity<?>> List<?> extractIds(Collection<T> entities) {
        List idList = CollectUtils.newArrayList();
        for (Entity element : entities) {
            try {
                idList.add(PropertyUtils.getProperty((Object)element, (String)"id"));
            }
            catch (Exception e) {
                logger.error("getProperty error", (Throwable)e);
            }
        }
        return idList;
    }

    public static String getCommandName(Class<?> clazz) {
        String name = clazz.getName();
        return Strings.uncapitalize((String)name.substring(name.lastIndexOf(46) + 1));
    }

    public static String getCommandName(String entityName) {
        return Strings.uncapitalize((String)Strings.substringAfterLast((String)entityName, (String)"."));
    }

    public static String getCommandName(Object obj) {
        String name = obj.getClass().getName();
        int dollar = name.indexOf("_$$_");
        name = -1 == dollar ? name.substring(name.lastIndexOf(46) + 1) : name.substring(name.lastIndexOf(46) + 1, dollar);
        return Strings.uncapitalize((String)name);
    }

    public static <T extends Entity<?>> String extractIdSeq(Collection<T> entities) {
        if (null == entities || entities.isEmpty()) {
            return "";
        }
        StringBuilder idBuf = new StringBuilder(",");
        for (Entity element : entities) {
            try {
                idBuf.append(PropertyUtils.getProperty((Object)element, (String)"id"));
                idBuf.append(',');
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return idBuf.toString();
    }

    public static boolean isEmpty(Entity<?> entity, boolean ignoreDefault) {
        try {
            for (String attr : PropertyUtils.getWritableProperties(entity.getClass())) {
                Object value = PropertyUtils.getProperty(entity, (String)attr);
                if (null == value) continue;
                if (ignoreDefault) {
                    if (value instanceof Number) {
                        if (((Number)value).intValue() == 0) continue;
                        return false;
                    }
                    if (value instanceof String) {
                        String str = (String)value;
                        if (!Strings.isNotEmpty((CharSequence)str)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
        }
        catch (Exception e) {
            logger.error("isEmpty error", (Throwable)e);
        }
        return true;
    }

    public static String getEntityClassName(Class<?> clazz) {
        String name = clazz.getName();
        int dollar = name.indexOf("_$$_");
        if (-1 == dollar) {
            return name;
        }
        return name.substring(0, dollar);
    }

    public static boolean isExpired(TemporalAt entity) {
        Date now = new Date();
        if (null == entity.getBeginAt()) {
            return true;
        }
        return entity.getBeginAt().after(now) || null != entity.getEndAt() && !now.before(entity.getEndAt());
    }

    public static boolean isExpired(TemporalOn entity) {
        Date now = new Date();
        if (null == entity.getBeginOn()) {
            return true;
        }
        return entity.getBeginOn().after(now) || null != entity.getEndOn() && !now.before(entity.getEndOn());
    }
}

