/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import org.beangle.commons.io.IOs;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.io.ItemReader;
import org.beangle.commons.transfer.io.TransferFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvItemReader
implements ItemReader {
    protected static final Logger logger = LoggerFactory.getLogger(CsvItemReader.class);
    LineNumberReader reader;
    private int headIndex = 0;
    private int dataIndex = 1;
    private int indexInCsv = 1;

    public CsvItemReader(LineNumberReader reader) {
        this.reader = reader;
    }

    @Override
    public String[] readDescription() {
        return null;
    }

    @Override
    public String[] readTitle() {
        try {
            this.reader.readLine();
            return Strings.split((String)this.reader.readLine(), (String)",");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void preRead() {
        while (this.indexInCsv < this.dataIndex) {
            try {
                this.reader.readLine();
            }
            catch (IOException e1) {
                logger.error("read csv", (Throwable)e1);
            }
            ++this.indexInCsv;
        }
    }

    @Override
    public Object read() {
        this.preRead();
        String curData = null;
        try {
            curData = this.reader.readLine();
        }
        catch (IOException e1) {
            logger.error(curData, (Throwable)e1);
        }
        ++this.indexInCsv;
        if (null == curData) {
            return null;
        }
        return Strings.split((String)curData, (String)",");
    }

    @Override
    public int getHeadIndex() {
        return this.headIndex;
    }

    @Override
    public void setHeadIndex(int headIndex) {
        if (this.dataIndex == this.headIndex + 1) {
            this.setDataIndex(headIndex + 1);
        }
        this.headIndex = headIndex;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public void setDataIndex(int dataIndex) {
        if (this.dataIndex == this.indexInCsv) {
            this.dataIndex = dataIndex;
            this.indexInCsv = dataIndex;
        }
    }

    @Override
    public TransferFormat getFormat() {
        return TransferFormat.Csv;
    }

    @Override
    public void close() {
        IOs.close((Closeable)this.reader);
    }
}

