/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.csv;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.beangle.commons.csv.CsvFormat;
import org.beangle.commons.csv.CsvWriter;
import org.beangle.commons.lang.Charsets;
import org.beangle.commons.transfer.io.AbstractItemWriter;
import org.beangle.commons.transfer.io.TransferFormat;

public class CsvItemWriter
extends AbstractItemWriter {
    protected CsvWriter csvr;
    protected CsvFormat csvFormat;

    public CsvItemWriter() {
    }

    public CsvItemWriter(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }

    @Override
    public void write(Object obj) {
        if (null == this.csvr) {
            this.csvr = null == this.csvFormat ? new CsvWriter((Writer)new OutputStreamWriter(this.outputStream, Charsets.UTF_8)) : new CsvWriter((Writer)new OutputStreamWriter(this.outputStream, Charsets.UTF_8), this.csvFormat);
        }
        if (null == obj) {
            return;
        }
        try {
            if (obj.getClass().isArray()) {
                Object[] values = (Object[])obj;
                String[] strValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    strValues[i] = null == values[i] ? "" : values[i].toString();
                }
                this.csvr.write(strValues);
            } else {
                this.csvr.write(new String[]{obj.toString()});
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void writeTitle(String titleName, Object data) {
        this.write(data);
    }

    @Override
    public void close() {
        try {
            this.csvr.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public TransferFormat getFormat() {
        return TransferFormat.Csv;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public CsvFormat getCsvFormat() {
        return this.csvFormat;
    }

    public void setCsvFormat(CsvFormat csvFormat) {
        this.csvFormat = csvFormat;
    }
}

