/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.excel;

import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.io.ItemReader;
import org.beangle.commons.transfer.io.TransferFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelItemReader
implements ItemReader {
    public static final Logger logger = LoggerFactory.getLogger(ExcelItemReader.class);
    public static int DEFAULT_HEADINDEX = 0;
    public static final NumberFormat numberFormat = NumberFormat.getInstance();
    public final int sheetNum = 0;
    private int headIndex;
    private int dataIndex;
    private int indexInSheet;
    private int attrCount = 0;
    private HSSFWorkbook workbook;

    public ExcelItemReader() {
    }

    public ExcelItemReader(InputStream is) {
        this(is, DEFAULT_HEADINDEX);
    }

    public ExcelItemReader(InputStream is, int headIndex) {
        try {
            this.init(new HSSFWorkbook(is), headIndex, headIndex + 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ExcelItemReader(HSSFWorkbook workbook, int headIndex) {
        this.init(workbook, headIndex, headIndex + 1);
    }

    private void init(HSSFWorkbook workbook, int headIndex, int dataIndex) {
        assert (workbook != null);
        this.workbook = workbook;
        this.headIndex = headIndex;
        this.dataIndex = dataIndex;
        this.indexInSheet = dataIndex;
    }

    public void setWorkbook(HSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public String[] readDescription() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return new String[0];
        }
        HSSFSheet sheet = this.workbook.getSheetAt(0);
        return this.readLine(sheet, 0);
    }

    @Override
    public String[] readTitle() {
        if (this.workbook.getNumberOfSheets() < 1) {
            return new String[0];
        }
        HSSFSheet sheet = this.workbook.getSheetAt(0);
        String[] attrs = this.readLine(sheet, this.headIndex);
        this.attrCount = attrs.length;
        return attrs;
    }

    protected String[] readLine(HSSFSheet sheet, int rowIndex) {
        String attr;
        HSSFCell cell;
        HSSFRow row = sheet.getRow(rowIndex);
        logger.debug("values count:{}", (Object)row.getLastCellNum());
        List attrList = CollectUtils.newArrayList();
        for (int i = 0; i < row.getLastCellNum() && null != (cell = row.getCell(i)) && !Strings.isEmpty((CharSequence)(attr = cell.getRichStringCellValue().getString())); ++i) {
            attrList.add(attr.trim());
        }
        Object[] attrs = new String[attrList.size()];
        attrList.toArray(attrs);
        logger.debug("has attrs {}", attrs);
        return attrs;
    }

    @Override
    public Object read() {
        HSSFSheet sheet = this.workbook.getSheetAt(0);
        if (this.indexInSheet > sheet.getLastRowNum()) {
            return null;
        }
        HSSFRow row = sheet.getRow(this.indexInSheet);
        ++this.indexInSheet;
        if (row == null) {
            return new Object[this.attrCount];
        }
        Object[] values = new Object[this.attrCount != 0 ? this.attrCount : (int)row.getLastCellNum()];
        for (int k = 0; k < values.length; ++k) {
            values[k] = ExcelItemReader.getCellValue(row.getCell(k));
        }
        return values;
    }

    public static Object getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 3: {
                return null;
            }
            case 1: {
                return Strings.trim((String)cell.getRichStringCellValue().getString());
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return numberFormat.format(cell.getNumericCellValue());
            }
            case 4: {
                return cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public TransferFormat getFormat() {
        return TransferFormat.Xls;
    }

    @Override
    public int getHeadIndex() {
        return this.headIndex;
    }

    @Override
    public void setHeadIndex(int headIndex) {
        if (this.dataIndex == this.headIndex + 1) {
            this.setDataIndex(headIndex + 1);
        }
        this.headIndex = headIndex;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public void setDataIndex(int dataIndex) {
        if (this.dataIndex == this.indexInSheet) {
            this.dataIndex = dataIndex;
            this.indexInSheet = dataIndex;
        }
    }

    @Override
    public void close() {
        this.workbook.cloneSheet(0);
    }

    static {
        numberFormat.setGroupingUsed(false);
    }
}

