/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.exporter;

import java.net.URL;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.csv.CsvItemWriter;
import org.beangle.commons.transfer.dbf.DBFItemWriter;
import org.beangle.commons.transfer.excel.ExcelItemWriter;
import org.beangle.commons.transfer.excel.ExcelTemplateWriter;
import org.beangle.commons.transfer.exporter.Context;
import org.beangle.commons.transfer.exporter.Exporter;
import org.beangle.commons.transfer.exporter.SimpleEntityExporter;
import org.beangle.commons.transfer.exporter.TemplateExporter;
import org.beangle.commons.transfer.io.TransferFormat;
import org.beangle.commons.transfer.io.Writer;

public final class ExporterFactory {
    public static Exporter getExporter(TransferFormat format, Context context) {
        String template = context.get("template", String.class);
        Exporter exporter = Strings.isNotBlank((CharSequence)template) ? new TemplateExporter() : new SimpleEntityExporter();
        exporter.setWriter(ExporterFactory.getWriter(format, context));
        return exporter;
    }

    private static Writer getWriter(TransferFormat format, Context context) {
        if (format.equals((Object)TransferFormat.Xls) || format.equals((Object)TransferFormat.Xlsx)) {
            String template = (String)context.get("template");
            if (Strings.isEmpty((CharSequence)template)) {
                return new ExcelItemWriter();
            }
            ExcelTemplateWriter writer = new ExcelTemplateWriter();
            URL templateURL = ClassLoaders.getResource((String)template, Exporter.class);
            if (null == templateURL) {
                throw new RuntimeException("Empty template path!");
            }
            writer.setTemplate(templateURL);
            return writer;
        }
        if (format.equals((Object)TransferFormat.Csv)) {
            return new CsvItemWriter();
        }
        if (format.equals((Object)TransferFormat.Dbf)) {
            return new DBFItemWriter();
        }
        throw new RuntimeException((Object)((Object)format) + " is not supported(choose xls,csv,dbf)");
    }
}

