/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.exporter;

import java.util.List;
import org.beangle.commons.transfer.exporter.AbstractItemExporter;
import org.beangle.commons.transfer.exporter.PropertyExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEntityExporter
extends AbstractItemExporter {
    private static final Logger logger = LoggerFactory.getLogger(MultiEntityExporter.class);
    protected PropertyExtractor propertyExtractor;
    protected List<Metadata> metadatas = null;

    @Override
    protected boolean beforeExport() {
        if (null == this.propertyExtractor) {
            this.propertyExtractor = this.context.get("extractor", PropertyExtractor.class);
        }
        if (null == this.metadatas) {
            this.metadatas = (List)this.context.get("metadatas");
        }
        if (null == this.metadatas || null == this.propertyExtractor) {
            logger.error("without metadatas or propertyExtractor,exporter stopped!");
            return false;
        }
        return true;
    }

    @Override
    public void transferItem() {
        Metadata metadata = this.metadatas.get(this.index);
        List values = (List)((List)this.context.get("items")).get(this.index);
        this.getWriter().writeTitle(metadata.dateName, metadata.titles);
        Object[] propValues = new Object[metadata.attrs.length];
        for (Object item : values) {
            for (int i = 0; i < propValues.length; ++i) {
                try {
                    propValues[i] = this.propertyExtractor.getPropertyValue(item, metadata.attrs[i]);
                    continue;
                }
                catch (Exception e) {
                    this.transferResult.addFailure("error.transfer.attrs.export", "occur in get property :" + metadata.attrs[i] + " and exception:" + e.getMessage());
                }
            }
            this.writer.write(propValues);
        }
    }

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExporter) {
        this.propertyExtractor = propertyExporter;
    }

    public static class Metadata {
        String dateName;
        String[] attrs;
        String[] titles;

        public Metadata(String dateName, String[] attrs, String[] titles) {
            this.dateName = dateName;
            this.attrs = attrs;
            this.titles = titles;
        }
    }
}

