/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.exporter;

import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.exporter.PropertyExtractor;
import org.beangle.commons.transfer.exporter.SimpleItemExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEntityExporter
extends SimpleItemExporter {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEntityExporter.class);
    protected String[] attrs;
    protected PropertyExtractor propertyExtractor;

    @Override
    protected boolean beforeExport() {
        String keys;
        if (null == this.attrs && Strings.isNotBlank((CharSequence)(keys = this.context.get("keys", String.class)))) {
            this.attrs = Strings.split((String)keys, (String)",");
        }
        if (null == this.propertyExtractor) {
            this.propertyExtractor = this.context.get("extractor", PropertyExtractor.class);
        }
        if (null == this.attrs || null == this.propertyExtractor) {
            logger.debug("attrs or propertyExtractor is null,transfer data as array.");
        }
        return super.beforeExport();
    }

    @Override
    public void transferItem() {
        if (null == this.attrs) {
            super.transferItem();
            return;
        }
        Object[] values = new Object[this.attrs.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                values[i] = this.propertyExtractor.getPropertyValue(this.getCurrent(), this.attrs[i]);
                continue;
            }
            catch (Exception e) {
                this.transferResult.addFailure("error.transfer.attrs.export", "occur in get property :" + this.attrs[i] + " and exception:" + e.getMessage());
            }
        }
        this.writer.write(values);
    }

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExporter) {
        this.propertyExtractor = propertyExporter;
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String[] attrs) {
        this.attrs = attrs;
    }
}

