/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.importer;

import java.util.Locale;
import java.util.Vector;
import org.beangle.commons.transfer.Transfer;
import org.beangle.commons.transfer.TransferListener;
import org.beangle.commons.transfer.TransferResult;
import org.beangle.commons.transfer.importer.ImportPrepare;
import org.beangle.commons.transfer.importer.Importer;
import org.beangle.commons.transfer.io.Reader;
import org.beangle.commons.transfer.io.TransferFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporter
implements Importer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImporter.class);
    protected Reader reader;
    protected TransferResult transferResult;
    protected ImportPrepare prepare;
    protected Vector<TransferListener> listeners = new Vector();
    protected int success = 0;
    protected int fail = 0;
    protected int index = 0;

    @Override
    public void transfer(TransferResult tr) {
        this.transferResult = tr;
        this.transferResult.setTransfer(this);
        long transferStartAt = System.currentTimeMillis();
        try {
            this.prepare.prepare(this);
        }
        catch (Exception e) {
            return;
        }
        for (TransferListener listener : this.listeners) {
            listener.onStart(tr);
        }
        while (this.read()) {
            long transferItemStart = System.currentTimeMillis();
            ++this.index;
            this.beforeImportItem();
            if (!this.isDataValid()) continue;
            int errors = tr.errors();
            for (TransferListener listener : this.listeners) {
                listener.onItemStart(tr);
            }
            if (tr.errors() > errors) continue;
            this.transferItem();
            for (TransferListener listener : this.listeners) {
                listener.onItemFinish(tr);
            }
            if (tr.errors() == errors) {
                ++this.success;
            } else {
                ++this.fail;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("importer item:{} take time: {}", (Object)this.getTranferIndex(), (Object)(System.currentTimeMillis() - transferItemStart));
        }
        for (TransferListener listener : this.listeners) {
            listener.onFinish(tr);
        }
        this.reader.close();
        logger.debug("importer elapse: {}", (Object)(System.currentTimeMillis() - transferStartAt));
    }

    @Override
    public int getFail() {
        return this.fail;
    }

    @Override
    public int getSuccess() {
        return this.success;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public boolean ignoreNull() {
        return true;
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public TransferFormat getFormat() {
        return this.reader.getFormat();
    }

    @Override
    public int getTranferIndex() {
        return this.index;
    }

    @Override
    public Transfer addListener(TransferListener listener) {
        this.listeners.add(listener);
        listener.setTransfer(this);
        return this;
    }

    @Override
    public ImportPrepare getPrepare() {
        return this.prepare;
    }

    @Override
    public void setPrepare(ImportPrepare prepare) {
        this.prepare = prepare;
    }

    protected void beforeImportItem() {
    }
}

