/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.importer;

import java.util.HashMap;
import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.ItemTransfer;
import org.beangle.commons.transfer.importer.AbstractImporter;
import org.beangle.commons.transfer.importer.DescriptionAttrPrepare;
import org.beangle.commons.transfer.importer.Importer;
import org.beangle.commons.transfer.io.ItemReader;
import org.beangle.commons.transfer.io.Reader;

public abstract class AbstractItemImporter
extends AbstractImporter
implements Importer,
ItemTransfer {
    protected Map<String, String> descriptions = new HashMap<String, String>();
    private String[] attrs;
    protected Map<String, Object> values = CollectUtils.newHashMap();

    public AbstractItemImporter() {
        this.prepare = new DescriptionAttrPrepare();
    }

    @Override
    public ItemReader getReader() {
        return (ItemReader)super.getReader();
    }

    @Override
    public void setReader(Reader reader) {
        if (!(reader instanceof ItemReader)) {
            throw new RuntimeException("Expected LineReader but\uff1a" + reader.getClass().getName());
        }
        this.reader = (ItemReader)reader;
    }

    public void changeCurValue(String attr, Object value) {
        this.values.put(attr, value);
    }

    @Override
    public final boolean read() {
        Object[] curData = (Object[])this.reader.read();
        if (null == curData) {
            this.setCurrent(null);
            this.setCurData(null);
            return false;
        }
        for (int i = 0; i < curData.length; ++i) {
            this.values.put(this.attrs[i], curData[i]);
        }
        return true;
    }

    @Override
    public boolean isDataValid() {
        boolean valid = false;
        for (Object value : this.values.values()) {
            if (value instanceof String) {
                String tt = (String)value;
                if (!Strings.isNotBlank((CharSequence)tt)) continue;
                valid = true;
                break;
            }
            if (null == value) continue;
            valid = true;
            break;
        }
        return valid;
    }

    @Override
    public Map<String, Object> getCurData() {
        return this.values;
    }

    @Override
    public void setCurData(Map<String, Object> curData) {
        this.values = curData;
    }

    @Override
    public String[] getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String[] attrs, String[] descs) {
        for (int i = 0; i < attrs.length && i < descs.length; ++i) {
            this.descriptions.put(attrs[i], descs[i]);
        }
        this.attrs = attrs;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public String processAttr(String attr) {
        return attr;
    }
}

