/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.importer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.EntityType;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.entity.metadata.ObjectAndType;
import org.beangle.commons.entity.metadata.Populator;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.importer.AbstractItemImporter;
import org.beangle.commons.transfer.importer.EntityImporter;
import org.beangle.commons.transfer.importer.IllegalImportFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiEntityImporter
extends AbstractItemImporter
implements EntityImporter {
    private final Logger logger = LoggerFactory.getLogger(MultiEntityImporter.class);
    protected Map<String, Object> current = CollectUtils.newHashMap();
    protected Set<String> foreignerKeys = CollectUtils.newHashSet();
    protected Populator populator = Model.getPopulator();
    protected Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();

    public MultiEntityImporter() {
        this.foreignerKeys.add("code");
    }

    @Override
    public void transferItem() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("tranfer index:{} : {}", (Object)this.getTranferIndex(), (Object)this.values);
        }
        for (Map.Entry entry : this.values.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                value = Strings.isBlank((CharSequence)strValue) ? null : Strings.trim((String)strValue);
            }
            if (null == value) continue;
            if (value.equals("null")) {
                value = null;
            }
            String key = (String)entry.getKey();
            Object entity = this.getCurrent(key);
            String attr = this.processAttr(key);
            String entityName = this.getEntityName(key);
            EntityType type = Model.getType(entityName);
            this.populateValue(entity, type, attr, value);
        }
    }

    protected void populateValue(Object entity, EntityType type, String attr, Object value) {
        String parentPath;
        ObjectAndType propertyType;
        Object property;
        boolean isForeigner;
        if (Strings.contains((CharSequence)attr, (int)46) && null != this.foreignerKeys && (isForeigner = this.isForeigner(attr)) && (property = (propertyType = this.populator.initProperty(entity, type, parentPath = Strings.substringBeforeLast((String)attr, (String)"."))).getObj()) instanceof Entity && ((Entity)property).isPersisted()) {
            this.populator.populateValue(entity, type, parentPath, null);
            this.populator.initProperty(entity, type, parentPath);
        }
        if (!this.populator.populateValue(entity, type, attr, value)) {
            this.transferResult.addFailure((String)this.descriptions.get(attr) + " data format error.", value);
        }
    }

    @Override
    public String processAttr(String attr) {
        return Strings.substringAfter((String)attr, (String)".");
    }

    protected Class<?> getEntityClass(String attr) {
        return this.getEntityType(attr).getEntityClass();
    }

    protected EntityType getEntityType(String attr) {
        String alias = Strings.substringBefore((String)attr, (String)".");
        EntityType entityType = this.entityTypes.get(alias);
        if (null == entityType) {
            entityType = this.entityTypes.get(attr);
        }
        return entityType;
    }

    public void addEntity(String alias, Class<?> entityClass) {
        EntityType entityType = Model.getType(entityClass);
        if (null == entityType) {
            throw new RuntimeException("cannot find entity type for " + entityClass);
        }
        this.entityTypes.put(alias, entityType);
    }

    public void addEntity(String alias, String entityName) {
        EntityType entityType = Model.getType(entityName);
        if (null == entityType) {
            throw new RuntimeException("cannot find entity type for " + entityName);
        }
        this.entityTypes.put(alias, entityType);
    }

    protected String getEntityName(String attr) {
        return this.getEntityType(attr).getEntityName();
    }

    public Object getCurrent(String attr) {
        String alias = Strings.substringBefore((String)attr, (String)".");
        Object entity = this.current.get(alias);
        if (null == entity) {
            EntityType entityType = this.entityTypes.get(alias);
            if (null == entityType) {
                this.logger.error("Not register entity type for {}", (Object)alias);
                throw new IllegalImportFormatException("Not register entity type for " + alias);
            }
            entity = entityType.newInstance();
            this.current.put(alias, entity);
            return entity;
        }
        return entity;
    }

    @Override
    public Object getCurrent() {
        return this.current;
    }

    @Override
    public void setCurrent(Object object) {
        this.current = (Map)object;
    }

    @Override
    public String getDataName() {
        return "multi entity";
    }

    @Override
    public void beforeImportItem() {
        this.current = CollectUtils.newHashMap();
    }

    private boolean isForeigner(String attr) {
        String property = Strings.substringAfterLast((String)attr, (String)".");
        return this.foreignerKeys.contains(property);
    }

    @Override
    public Set<String> getForeignerKeys() {
        return this.foreignerKeys;
    }

    public void setForeignerKeys(Set<String> foreignerKeys) {
        this.foreignerKeys = foreignerKeys;
    }

    @Override
    public void addForeignedKeys(String foreignerKey) {
        this.foreignerKeys.add(foreignerKey);
    }

    @Override
    public void setPopulator(Populator populator) {
        this.populator = populator;
    }

    public Map<String, EntityType> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Map<String, EntityType> entityTypes) {
        this.entityTypes = entityTypes;
    }
}

