/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.importer.listener;

import java.util.List;
import java.util.Map;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.Model;
import org.beangle.commons.entity.util.EntityUtils;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.transfer.TransferResult;
import org.beangle.commons.transfer.importer.MultiEntityImporter;
import org.beangle.commons.transfer.importer.listener.ItemImporterListener;

public class ImporterForeignerListener
extends ItemImporterListener {
    protected EntityDao entityDao;
    protected Map<String, Map<String, Object>> foreigersMap = CollectUtils.newHashMap();
    private static final int CACHE_SIZE = 500;
    private String[] foreigerKeys = new String[]{"code"};
    private boolean multiEntity = false;

    public ImporterForeignerListener(EntityDao entityDao) {
        this.entityDao = entityDao;
    }

    @Override
    public void onStart(TransferResult tr) {
        if (this.importer.getClass().equals(MultiEntityImporter.class)) {
            this.multiEntity = true;
        }
        super.onStart(tr);
    }

    @Override
    public void onItemFinish(TransferResult tr) {
        for (int i = 0; i < this.importer.getAttrs().length; ++i) {
            int foreigerKeyIndex;
            String attr = this.importer.getAttrs()[i];
            String processed = this.importer.processAttr(attr);
            boolean isforeiger = false;
            for (foreigerKeyIndex = 0; foreigerKeyIndex < this.foreigerKeys.length; ++foreigerKeyIndex) {
                if (!processed.endsWith("." + this.foreigerKeys[foreigerKeyIndex])) continue;
                isforeiger = true;
                break;
            }
            if (!isforeiger) continue;
            String codeValue = (String)this.importer.getCurData().get(attr);
            try {
                Object foreiger = null;
                if (Strings.isEmpty((CharSequence)codeValue)) continue;
                Object entity = null;
                entity = this.multiEntity ? ((MultiEntityImporter)this.importer).getCurrent(attr) : this.importer.getCurrent();
                Object nestedForeigner = PropertyUtils.getProperty((Object)entity, (String)Strings.substring((String)(attr = this.importer.processAttr(attr)), (int)0, (int)attr.lastIndexOf(".")));
                if (nestedForeigner instanceof Entity) {
                    String className = EntityUtils.getEntityClassName(nestedForeigner.getClass());
                    Map foreignerMap = this.foreigersMap.get(className);
                    if (null == foreignerMap) {
                        foreignerMap = CollectUtils.newHashMap();
                        this.foreigersMap.put(className, foreignerMap);
                    }
                    if (foreignerMap.size() > 500) {
                        foreignerMap.clear();
                    }
                    if ((foreiger = (Object)foreignerMap.get(codeValue)) == null) {
                        List<?> foreigners = this.entityDao.get(Class.forName(className), this.foreigerKeys[foreigerKeyIndex], codeValue);
                        if (!foreigners.isEmpty()) {
                            foreiger = foreigners.iterator().next();
                            foreignerMap.put(codeValue, foreiger);
                        } else {
                            tr.addFailure("error.model.notExist", codeValue);
                        }
                    }
                }
                String parentAttr = Strings.substring((String)attr, (int)0, (int)attr.lastIndexOf("."));
                Model.getPopulator().populateValue(entity, Model.getType(entity.getClass()), parentAttr, foreiger);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addForeigerKey(String key) {
        String[] foreigers = new String[this.foreigerKeys.length + 1];
        for (int i = 0; i < this.foreigerKeys.length; ++i) {
            foreigers[i] = this.foreigerKeys[i];
        }
        foreigers[i] = key;
        this.foreigerKeys = foreigers;
    }
}

