/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class FileTool {
    private FileTool() {
    }

    public static String getPath() {
        return System.getProperty("user.dir");
    }

    public static boolean createFile(String path) {
        File file = new File(path);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file.exists();
    }

    public static void writeFile(File file, String content, boolean isAppend) {
        Writer writer = null;
        try {
            writer = new FileWriter(file, isAppend);
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String readFile(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
    }
}

