/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.config;

import org.dromara.sms4j.aliyun.config.AlibabaConfig;
import org.dromara.sms4j.aliyun.config.AlibabaFactory;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.cloopen.config.CloopenFactory;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.dromara.sms4j.ctyun.config.CtyunConfig;
import org.dromara.sms4j.ctyun.config.CtyunFactory;
import org.dromara.sms4j.emay.config.EmayConfig;
import org.dromara.sms4j.emay.config.EmayFactory;
import org.dromara.sms4j.huawei.config.HuaweiConfig;
import org.dromara.sms4j.huawei.config.HuaweiFactory;
import org.dromara.sms4j.jdcloud.config.JdCloudConfig;
import org.dromara.sms4j.jdcloud.config.JdCloudFactory;
import org.dromara.sms4j.netease.config.NeteaseConfig;
import org.dromara.sms4j.netease.config.NeteaseFactory;
import org.dromara.sms4j.provider.enumerate.SupplierType;
import org.dromara.sms4j.tencent.config.TencentConfig;
import org.dromara.sms4j.tencent.config.TencentFactory;
import org.dromara.sms4j.unisms.config.UniConfig;
import org.dromara.sms4j.unisms.config.UniFactory;
import org.dromara.sms4j.yunpian.config.YunPianFactory;
import org.dromara.sms4j.yunpian.config.YunpianConfig;

public class SupplierFactory {
    private SupplierFactory() {
    }

    public static AlibabaConfig getAlibabaConfig() {
        return AlibabaFactory.instance().getConfig();
    }

    public static HuaweiConfig getHuaweiConfig() {
        return HuaweiFactory.instance().getConfig();
    }

    public static UniConfig getUniConfig() {
        return UniFactory.instance().getConfig();
    }

    public static TencentConfig getTencentConfig() {
        return TencentFactory.instance().getConfig();
    }

    public static YunpianConfig getYunpianConfig() {
        return YunPianFactory.instance().getConfig();
    }

    public static JdCloudConfig getJdCloudConfig() {
        return JdCloudFactory.instance().getConfig();
    }

    public static CloopenConfig getCloopenConfig() {
        return CloopenFactory.instance().getConfig();
    }

    public static EmayConfig getEmayConfig() {
        return EmayFactory.instance().getConfig();
    }

    public static CtyunConfig getCtyunConfig() {
        return CtyunFactory.instance().getConfig();
    }

    public static NeteaseConfig getNeteaseConfig() {
        return NeteaseFactory.instance().getConfig();
    }

    public static <T extends SupplierConfig> void setSupplierConfig(T t) {
        if (t instanceof AlibabaConfig) {
            SupplierFactory.setAlibabaConfig((AlibabaConfig)t);
        } else if (t instanceof HuaweiConfig) {
            SupplierFactory.setHuaweiConfig((HuaweiConfig)t);
        } else if (t instanceof UniConfig) {
            SupplierFactory.setUniConfig((UniConfig)t);
        } else if (t instanceof TencentConfig) {
            SupplierFactory.setTencentConfig((TencentConfig)t);
        } else if (t instanceof YunpianConfig) {
            SupplierFactory.setYunpianConfig((YunpianConfig)t);
        } else if (t instanceof JdCloudConfig) {
            SupplierFactory.setJdCloudConfig((JdCloudConfig)t);
        } else if (t instanceof CloopenConfig) {
            SupplierFactory.setCloopenConfig((CloopenConfig)t);
        } else if (t instanceof EmayConfig) {
            SupplierFactory.setEmayConfig((EmayConfig)t);
        } else if (t instanceof CtyunConfig) {
            SupplierFactory.setCtyunConfig((CtyunConfig)t);
        } else if (t instanceof NeteaseConfig) {
            SupplierFactory.setNeteaseConfig((NeteaseConfig)t);
        } else {
            throw new SmsBlendException("Loading failure! Please check the configuration type.");
        }
    }

    public static void setAlibabaConfig(AlibabaConfig alibabaConfig) {
        AlibabaFactory.instance().setConfig(alibabaConfig);
        SmsFactory.refresh(SupplierType.ALIBABA);
    }

    public static void setHuaweiConfig(HuaweiConfig huaweiConfig) {
        HuaweiFactory.instance().setConfig(huaweiConfig);
        SmsFactory.refresh(SupplierType.HUAWEI);
    }

    public static void setUniConfig(UniConfig uniConfig) {
        UniFactory.instance().setConfig(uniConfig);
        SmsFactory.refresh(SupplierType.UNI_SMS);
    }

    public static void setTencentConfig(TencentConfig tencentConfig) {
        TencentFactory.instance().setConfig(tencentConfig);
        SmsFactory.refresh(SupplierType.TENCENT);
    }

    public static void setYunpianConfig(YunpianConfig yunpianConfig) {
        YunPianFactory.instance().setConfig(yunpianConfig);
        SmsFactory.refresh(SupplierType.YUNPIAN);
    }

    public static void setJdCloudConfig(JdCloudConfig jdCloudConfig) {
        JdCloudFactory.instance().setConfig(jdCloudConfig);
        SmsFactory.refresh(SupplierType.JD_CLOUD);
    }

    public static void setCloopenConfig(CloopenConfig cloopenConfig) {
        CloopenFactory.instance().setConfig(cloopenConfig);
        SmsFactory.refresh(SupplierType.CLOOPEN);
    }

    public static void setEmayConfig(EmayConfig emayConfig) {
        EmayFactory.instance().setConfig(emayConfig);
        SmsFactory.refresh(SupplierType.EMAY);
    }

    public static void setCtyunConfig(CtyunConfig ctyunConfig) {
        CtyunFactory.instance().setConfig(ctyunConfig);
        SmsFactory.refresh(SupplierType.CTYUN);
    }

    public static void setNeteaseConfig(NeteaseConfig neteaseConfig) {
        NeteaseFactory.instance().setConfig(neteaseConfig);
        SmsFactory.refresh(SupplierType.NETEASE);
    }
}

