/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.core.proxy.SmsProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(SmsInvocationHandler.class);
    private final SmsBlend smsBlend;

    public SmsInvocationHandler(SmsBlend smsBlend) {
        this.smsBlend = smsBlend;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) {
        Object result = null;
        objects = this.doPreProcess(this.smsBlend, method, objects);
        try {
            result = method.invoke((Object)this.smsBlend, objects);
        }
        catch (Exception e) {
            this.doErrorHandleProcess(this.smsBlend, method, objects, e);
        }
        return this.doPostrocess(this.smsBlend, method, objects, result);
    }

    public Object[] doPreProcess(Object o, Method method, Object[] objects) {
        for (SmsProcessor processor : SmsProxyFactory.getProcessors()) {
            objects = processor.preProcessor(method, o, objects);
        }
        return objects;
    }

    public void doErrorHandleProcess(Object o, Method method, Object[] objects, Exception e) throws RuntimeException {
        for (SmsProcessor processor : SmsProxyFactory.getProcessors()) {
            processor.exceptionHandleProcessor(method, o, objects, e);
        }
    }

    public Object doPostrocess(Object o, Method method, Object[] objects, Object result) {
        for (SmsProcessor processor : SmsProxyFactory.getProcessors()) {
            Object overrideResult;
            if (!Objects.nonNull(result) || !(result instanceof SmsResponse) || (overrideResult = processor.postProcessor((SmsResponse)result, objects)) == null) continue;
            return overrideResult;
        }
        return result;
    }
}

