/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.proxy.CoreMethodProcessor;
import org.dromara.sms4j.api.proxy.aware.SmsDaoAware;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackListProcessor
implements CoreMethodProcessor,
SmsDaoAware {
    private static final Logger log = LoggerFactory.getLogger(BlackListProcessor.class);
    SmsDao smsDao;

    public int getOrder() {
        return 0;
    }

    public void sendMessagePreProcess(String phone, Object message) {
        this.doRestricted(Collections.singletonList(phone));
    }

    public void sendMessageByTemplatePreProcess(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.doRestricted(Collections.singletonList(phone));
    }

    public void massTextingPreProcess(List<String> phones, String message) {
        this.doRestricted(phones);
    }

    public void massTextingByTemplatePreProcess(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        this.doRestricted(phones);
    }

    public void doRestricted(List<String> phones) {
        ArrayList blackList = (ArrayList)this.smsDao.get("sms:blacklist:global");
        if (null == blackList) {
            return;
        }
        for (String phone : phones) {
            if (!blackList.stream().anyMatch(black -> black.replace("-", "").equals(phone))) continue;
            throw new SmsBlendException("The phone:", phone + " hit global blacklist\uff01");
        }
    }

    public void setSmsDao(SmsDao smsDao) {
        this.smsDao = smsDao;
    }
}

