/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.core.proxy.processor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.proxy.CoreMethodProcessor;
import org.dromara.sms4j.api.proxy.aware.SmsDaoAware;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedProcessor
implements CoreMethodProcessor,
SmsDaoAware {
    private static final Logger log = LoggerFactory.getLogger(RestrictedProcessor.class);
    static Long minTimer = 60000L;
    static Long accTimer = 86400000L;
    private static final String REDIS_KEY = "sms:restricted:";
    private SmsDao smsDao;

    public int getOrder() {
        return 3;
    }

    public void sendMessagePreProcess(String phone, Object message) {
        this.doRestricted(Collections.singletonList(phone));
    }

    public void sendMessageByTemplatePreProcess(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.doRestricted(Collections.singletonList(phone));
    }

    public void massTextingPreProcess(List<String> phones, String message) {
        this.doRestricted(phones);
    }

    public void massTextingByTemplatePreProcess(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        this.doRestricted(phones);
    }

    public void doRestricted(List<String> phones) {
        boolean isNoProcessing;
        if (Objects.isNull(this.smsDao)) {
            throw new SmsBlendException("The smsDao tool could not be found");
        }
        SmsConfig config = BeanFactory.getSmsConfig();
        Integer accountMax = config.getAccountMax();
        Integer minuteMax = config.getMinuteMax();
        boolean dailyMaxLimitExists = SmsUtils.isNotEmpty((Object)accountMax);
        boolean perMinuteLimitExists = SmsUtils.isNotEmpty((Object)minuteMax);
        boolean bl = isNoProcessing = config.getRestricted() == false || !dailyMaxLimitExists && !perMinuteLimitExists;
        if (isNoProcessing) {
            return;
        }
        for (String phone : phones) {
            String minuteMaxKey = REDIS_KEY + phone;
            String accountMaxKey = minuteMaxKey.concat("max");
            if (dailyMaxLimitExists) {
                Integer dailyCount = (Integer)this.smsDao.get(accountMaxKey);
                if (SmsUtils.isEmpty((Object)dailyCount)) {
                    this.smsDao.set(accountMaxKey, (Object)1, accTimer / 1000L);
                } else {
                    if (dailyCount >= accountMax) {
                        log.info("The phone: {},number of short messages reached the maximum today", (Object)phone);
                        throw new SmsBlendException("The phone: {},number of short messages reached the maximum today", phone);
                    }
                    this.smsDao.set(accountMaxKey, (Object)(dailyCount + 1), accTimer / 1000L);
                }
            }
            if (!perMinuteLimitExists) continue;
            Integer minuteCount = (Integer)this.smsDao.get(REDIS_KEY + phone);
            if (SmsUtils.isNotEmpty((Object)minuteCount)) {
                if (minuteCount < minuteMax) {
                    this.smsDao.set(minuteMaxKey, (Object)(minuteCount + 1), minTimer / 1000L);
                    continue;
                }
                if (dailyMaxLimitExists) {
                    Integer dailyCount = (Integer)this.smsDao.get(accountMaxKey);
                    if (dailyCount > 1) {
                        this.smsDao.set(accountMaxKey, (Object)(dailyCount - 1), accTimer / 1000L);
                    } else {
                        this.smsDao.remove(accountMaxKey);
                    }
                }
                log.info("The phone: {} Text messages are sent too often\uff01", (Object)phone);
                throw new SmsBlendException("The phone: {} Text messages are sent too often\uff01", phone);
            }
            this.smsDao.set(minuteMaxKey, (Object)1, minTimer / 1000L);
        }
    }

    public void setSmsDao(SmsDao smsDao) {
        this.smsDao = smsDao;
    }
}

