/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.cloopen.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import com.dtflys.forest.Forest;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.cloopen.api.CloopenRestApi;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.cloopen.util.CloopenHelper;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloopenSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(CloopenSmsImpl.class);
    private final CloopenRestApi restApi;
    private final CloopenConfig config;

    public CloopenSmsImpl(CloopenConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
        this.restApi = (CloopenRestApi)Forest.client(CloopenRestApi.class);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        return this.massTexting(Collections.singletonList(phone), message);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        return this.massTexting(Collections.singletonList(phone), templateId, messages);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(IdUtil.fastSimpleUUID(), message);
        return this.massTexting(phones, this.config.getTemplateId(), map);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        CloopenHelper helper = new CloopenHelper(this.config);
        HashMap paramMap = MapUtil.newHashMap((int)4);
        paramMap.put("to", String.join((CharSequence)",", phones));
        paramMap.put("appId", this.config.getAppId());
        paramMap.put("templateId", templateId);
        paramMap.put("datas", messages.keySet().stream().map(messages::get).toArray(String[]::new));
        return helper.request(this.restApi::sendSms, paramMap);
    }
}

