/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.cloopen.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONUtil;
import com.dtflys.forest.Forest;
import com.dtflys.forest.config.ForestConfiguration;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.cloopen.config.CloopenConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.RestApiFunction;

public class CloopenHelper {
    private final CloopenConfig config;

    public CloopenHelper(CloopenConfig config) {
        this.config = config;
    }

    public <R> SmsResponse request(RestApiFunction<Map<String, Object>, R> restApiFunction, Map<String, Object> paramMap) {
        SmsResponse smsResponse = new SmsResponse();
        try {
            String timestamp = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            ForestConfiguration forestConfiguration = Forest.config();
            forestConfiguration.setVariableValue("baseUrl", method -> this.config.getBaseUrl());
            forestConfiguration.setVariableValue("accessKeyId", method -> this.config.getAccessKeyId());
            forestConfiguration.setVariableValue("sign", (Object)this.generateSign(this.config.getAccessKeyId(), this.config.getAccessKeySecret(), timestamp));
            forestConfiguration.setVariableValue("authorization", (Object)this.generateAuthorization(this.config.getAccessKeyId(), timestamp));
            Object response = restApiFunction.apply(paramMap);
            Map responseMap = Optional.ofNullable(response).map(JSONUtil::parseObj).map(obj -> obj).orElse(Collections.emptyMap());
            String statusCode = Convert.toStr(responseMap.get("statusCode"));
            String statusMsg = Convert.toStr(responseMap.get("statusMsg"));
            boolean isSuccess = "000000".equals(statusCode);
            if (isSuccess) {
                smsResponse.setSuccess(true);
                smsResponse.setCode(statusCode);
                smsResponse.setMessage(statusMsg);
                smsResponse.setData(response);
                Object bizId = JSONUtil.getByPath((JSON)JSONUtil.parse(responseMap), (String)"templateSMS.smsMessageSid");
                smsResponse.setBizId(Convert.toStr((Object)bizId));
            } else {
                smsResponse.setErrMessage(statusMsg);
                smsResponse.setErrorCode(statusCode);
            }
        }
        catch (Exception e) {
            throw new SmsBlendException(e.getMessage());
        }
        return smsResponse;
    }

    private String generateSign(String accessKeyId, String accessKeySecret, String timestamp) {
        return SecureUtil.md5((String)(accessKeyId + accessKeySecret + timestamp)).toUpperCase();
    }

    private String generateAuthorization(String accessKeyId, String timestamp) {
        return Base64.encode((CharSequence)(accessKeyId + ":" + timestamp));
    }
}

