/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.huawei.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.AbstractSmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.huawei.config.HuaweiConfig;
import org.dromara.sms4j.huawei.entity.HuaweiResponse;
import org.dromara.sms4j.huawei.utils.HuaweiBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiSmsImpl
extends AbstractSmsBlend {
    private static final Logger log = LoggerFactory.getLogger(HuaweiSmsImpl.class);
    private final HuaweiConfig config;

    public HuaweiSmsImpl(HuaweiConfig config, Executor pool, DelayedTime delayed) {
        super(pool, delayed);
        this.config = config;
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String message) {
        LinkedHashMap<String, String> mes = new LinkedHashMap<String, String>();
        mes.put(UUID.randomUUID().toString().replaceAll("-", ""), message);
        return this.sendMessage(phone, this.config.getTemplateId(), mes);
    }

    @Restricted
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        String url = this.config.getUrl() + "/sms/batchSendSms/v1";
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        String mess = HuaweiBuilder.listToString(list);
        String requestBody = HuaweiBuilder.buildRequestBody(this.config.getSender(), phone, templateId, mess, this.config.getStatusCallBack(), this.config.getSignature());
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Authorization", "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"");
        headers.put("X-WSSE", HuaweiBuilder.buildWsseHeader(this.config.getAppKey(), this.config.getAppSecret()));
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        SmsResponse smsResponse = new SmsResponse();
        this.http.post(url).addHeader(headers).addBody(requestBody).onSuccess((data, req, res) -> {
            HuaweiResponse jsonBody = (HuaweiResponse)res.get(HuaweiResponse.class);
            smsResponse.setCode(jsonBody.getCode());
            smsResponse.setMessage(jsonBody.getDescription());
            smsResponse.setBizId(jsonBody.getResult().get(0).getSmsMsgId());
            smsResponse.setData(jsonBody.getResult());
            if ("000000".equals(jsonBody.getCode())) {
                smsResponse.setSuccess(true);
            }
        }).onError((ex, req, res) -> {
            HuaweiResponse huaweiResponse = (HuaweiResponse)res.get(HuaweiResponse.class);
            if (huaweiResponse == null) {
                smsResponse.setErrorCode("500");
                smsResponse.setErrMessage("huawei send sms response is null.check param");
            } else {
                smsResponse.setErrMessage(huaweiResponse.getDescription());
                smsResponse.setErrorCode(huaweiResponse.getCode());
            }
        }).execute();
        return smsResponse;
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.sendMessage(HuaweiBuilder.listToString(phones), message);
    }

    @Restricted
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        return this.sendMessage(HuaweiBuilder.listToString(phones), templateId, messages);
    }
}

