/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.netease.config;

import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.netease.config.NeteaseConfig;
import org.dromara.sms4j.netease.service.NeteaseSmsImpl;
import org.dromara.sms4j.provider.base.BaseProviderFactory;

public class NeteaseFactory
implements BaseProviderFactory<NeteaseSmsImpl, NeteaseConfig> {
    private static NeteaseSmsImpl neteaseSms;
    private static final NeteaseFactory INSTANCE;

    private NeteaseFactory() {
    }

    public static NeteaseFactory instance() {
        return INSTANCE;
    }

    @Override
    public NeteaseSmsImpl createSms(NeteaseConfig neteaseConfig) {
        if (neteaseSms == null) {
            neteaseSms = new NeteaseSmsImpl(neteaseConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        }
        return neteaseSms;
    }

    @Override
    public NeteaseSmsImpl createMultitonSms(NeteaseConfig neteaseConfig) {
        return new NeteaseSmsImpl(neteaseConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
    }

    @Override
    public NeteaseSmsImpl refresh(NeteaseConfig neteaseConfig) {
        neteaseSms = new NeteaseSmsImpl(neteaseConfig, BeanFactory.getExecutor(), BeanFactory.getDelayedTime());
        return neteaseSms;
    }

    @Override
    public NeteaseConfig getConfig() {
        return ConfigHolder.config;
    }

    @Override
    public void setConfig(NeteaseConfig config) {
        ConfigHolder.config = config;
    }

    static {
        INSTANCE = new NeteaseFactory();
    }

    private static final class ConfigHolder {
        private static NeteaseConfig config = NeteaseConfig.builder().build();

        private ConfigHolder() {
        }
    }
}

